/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.util;

import com.jronimo.temporal.Constants;
import com.jronimo.temporal.DateTime;
import com.jronimo.temporal.StringFormat;
import com.jronimo.temporal.Timezone;
import com.jronimo.text.ResourceTextIdentifiers;
import com.jronimo.text.ResourceTextPointer;
import com.jronimo.util.Assert;
import com.jronimo.util.Logger;
import com.jronimo.util.NameFormat;
import com.jronimo.util.StringWrapper;
import com.jronimo.util.StringWrapperWithVoidRegions;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

public class DateUtils {
    private static final Logger logger = Logger.getLogger(DateUtils.class);
    private static List<String> monthAbbrevs = new ArrayList<String>(12);
    private static long uniqueTimestamp;
    private static DateTime uniqueDateTime;

    protected DateUtils() {
    }

    public static synchronized long getUniqueTimestamp() {
        return DateUtils.getUniqueTimestamp(false);
    }

    public static synchronized long getUniqueTimestamp(boolean bl) {
        long l = 0L;
        while ((l = System.currentTimeMillis()) == uniqueTimestamp) {
        }
        uniqueTimestamp = l;
        if (bl) {
            l = DateUtils.convertToUTCZero(l);
        }
        return l;
    }

    public static synchronized String getUniqueDateTimeString(boolean bl) {
        String string = null;
        DateTime dateTime = null;
        StringFormat stringFormat = null;
        StringFormat.DateFormat dateFormat = null;
        StringFormat.TimeFormat timeFormat = null;
        StringFormat.TimezoneFormat timezoneFormat = null;
        while ((dateTime = DateTime.now(bl)).equalTo(uniqueDateTime, true)) {
        }
        uniqueDateTime = dateTime;
        dateFormat = new StringFormat.DateFormat(true);
        dateFormat.setSeparatorIfNull(Constants.DateSeparator.NONE);
        timeFormat = new StringFormat.TimeFormat(true);
        timeFormat.setSeparatorIfNull(Constants.TimeSeparator.NONE);
        timeFormat.setIncludeLeadingSpaceIfNull(false);
        timezoneFormat = new StringFormat.TimezoneFormat(false);
        stringFormat = new StringFormat(dateFormat, timeFormat, timezoneFormat);
        string = DateUtils.getUniqueDateTime(true).getString(stringFormat);
        return string;
    }

    public static synchronized String getHttpDateString(DateTime dateTime) {
        StringWrapper stringWrapper = null;
        stringWrapper = new StringWrapper();
        stringWrapper.append(dateTime.getDayOfWeekShortName()).append(", ").append(dateTime.getDay()).append(" ").append(new NameFormat(DateUtils.getMonthAbbreviation(dateTime.getMonth())).getCamelCase()).append(" ").append(dateTime.getYear()).append(" ").append(dateTime.getHour()).append(":").append(dateTime.getMinute()).append(":").append(dateTime.getSecond()).append(" GMT");
        return stringWrapper.toString();
    }

    public static synchronized DateTime getUniqueDateTime(boolean bl) {
        DateTime dateTime = null;
        while ((dateTime = DateTime.now(bl)).equalTo(uniqueDateTime, true)) {
        }
        uniqueDateTime = dateTime;
        return dateTime;
    }

    public static synchronized DateTime getUniqueDateTime() {
        return DateUtils.getUniqueDateTime(0);
    }

    public static synchronized DateTime getUniqueDateTime(int n) {
        DateTime dateTime = null;
        while ((dateTime = DateTime.now(n)).equalTo(uniqueDateTime, true)) {
        }
        uniqueDateTime = dateTime;
        return dateTime;
    }

    public static synchronized long getUniqueDateTimeTemporalValue() {
        return DateUtils.getUniqueDateTime().getTemporalValue();
    }

    public static synchronized long getUniqueDateTimeTemporalValue(int n) {
        return DateUtils.getUniqueDateTime(n).getTemporalValue();
    }

    public static synchronized long getUniqueDateTimeTemporalValue(boolean bl) {
        return DateUtils.getUniqueDateTime(bl).getTemporalValue();
    }

    public static synchronized long convertToUTCZero(Timestamp timestamp) {
        long l = 0L;
        l = DateUtils.convertToUTCZero(timestamp.getTime());
        return l;
    }

    public static synchronized long convertToUTCZero(long l) {
        long l2 = 0L;
        Calendar calendar = null;
        Timezone timezone = null;
        calendar = Calendar.getInstance();
        calendar.setTimeInMillis(l);
        timezone = Timezone.getTimezoneByJavaId(calendar.getTimeZone().getID());
        l2 = l - (long)timezone.getOffsetAdjustment(calendar);
        return l2;
    }

    public static Date createZeroTimeDate(Date date) {
        Date date2 = null;
        Calendar calendar = null;
        Assert.errorParam(date == null, new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_NOT_BE_NULL, "date"));
        calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        date2 = new Date(calendar.getTime().getTime());
        return date2;
    }

    public static Date createZeroTimeDate(int n, int n2, int n3) {
        Date date = null;
        Calendar calendar = null;
        calendar = Calendar.getInstance();
        calendar.set(1, n);
        calendar.set(2, n2);
        calendar.set(5, n3);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        date = calendar.getTime();
        return date;
    }

    public static Date createEndOfDayDate(Date date) {
        Date date2 = null;
        Calendar calendar = null;
        Assert.errorParam(date == null, new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_NOT_BE_NULL, "date"));
        calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 999);
        date2 = new Date(calendar.getTime().getTime());
        return date2;
    }

    public static Date createEndOfDayDate(int n, int n2, int n3) {
        Date date = null;
        Calendar calendar = null;
        calendar = Calendar.getInstance();
        calendar.set(1, n);
        calendar.set(2, n2);
        calendar.set(5, n3);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 999);
        date = calendar.getTime();
        return date;
    }

    public static boolean before(Date date, Date date2) {
        boolean bl = false;
        Assert.errorParam(date == null, new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_NOT_BE_NULL, "masterDate"));
        Assert.errorParam(date2 == null, new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_NOT_BE_NULL, "comparisonDate"));
        bl = date2.getTime() < date.getTime();
        return bl;
    }

    public static boolean after(Date date, Date date2) {
        boolean bl = false;
        Assert.errorParam(date == null, new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_NOT_BE_NULL, "masterDate"));
        Assert.errorParam(date2 == null, new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_NOT_BE_NULL, "comparisonDate"));
        bl = date2.getTime() < date.getTime();
        return bl;
    }

    public static boolean identical(Date date, Date date2) {
        boolean bl = false;
        Assert.errorParam(date == null, new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_NOT_BE_NULL, "masterDate"));
        Assert.errorParam(date2 == null, new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_NOT_BE_NULL, "comparisonDate"));
        bl = date2.getTime() == date.getTime();
        return bl;
    }

    public static int getMonthNumber(String string) {
        int n = 0;
        Assert.errorParam(string == null, new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_NOT_BE_NULL, "monthText"));
        Assert.errorParam(string.length() < 3, new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_HAVE_LENGTH_GREATER_THAN_OR_EQUAL_TO, "monthText", String.valueOf(3)));
        string = string.toUpperCase().substring(0, 3);
        n = monthAbbrevs.indexOf(string) + 1;
        Assert.errorParam(n == 0, new ResourceTextPointer((Object)ResourceTextIdentifiers.UNRECOGNIZED_VALUE, "monthText", string));
        return n;
    }

    public static String calendarToDateTimeString(Calendar calendar) {
        StringBuffer stringBuffer = null;
        stringBuffer = new StringBuffer();
        stringBuffer.append(calendar.get(1));
        stringBuffer.append("-");
        stringBuffer.append(monthAbbrevs.get(calendar.get(2)));
        stringBuffer.append("-");
        stringBuffer.append(new StringWrapperWithVoidRegions(calendar.get(5)).pad(2, "0", false));
        stringBuffer.append(" ");
        stringBuffer.append(new StringWrapperWithVoidRegions(calendar.get(11)).pad(2, "0", false));
        stringBuffer.append(":");
        stringBuffer.append(new StringWrapperWithVoidRegions(calendar.get(12)).pad(2, "0", false));
        stringBuffer.append(":");
        stringBuffer.append(new StringWrapperWithVoidRegions(calendar.get(13)).pad(2, "0", false));
        stringBuffer.append(".");
        stringBuffer.append(new StringWrapperWithVoidRegions(calendar.get(14)).pad(3, "0", false));
        return stringBuffer.toString();
    }

    public static String calendarToDateString(Calendar calendar) {
        StringBuffer stringBuffer = null;
        stringBuffer = new StringBuffer();
        stringBuffer.append(calendar.get(1));
        stringBuffer.append("-");
        stringBuffer.append(monthAbbrevs.get(calendar.get(2)));
        stringBuffer.append("-");
        stringBuffer.append(new StringWrapperWithVoidRegions(calendar.get(5)).pad(2, "0", false));
        return stringBuffer.toString();
    }

    public static String getMonthAbbreviation(int n) {
        String string = null;
        string = monthAbbrevs.get(n - 1);
        return string;
    }

    static {
        monthAbbrevs.add("JAN");
        monthAbbrevs.add("FEB");
        monthAbbrevs.add("MAR");
        monthAbbrevs.add("APR");
        monthAbbrevs.add("MAY");
        monthAbbrevs.add("JUN");
        monthAbbrevs.add("JUL");
        monthAbbrevs.add("AUG");
        monthAbbrevs.add("SEP");
        monthAbbrevs.add("OCT");
        monthAbbrevs.add("NOV");
        monthAbbrevs.add("DEC");
    }
}

