/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.util;

import java.io.File;
import java.io.FileFilter;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicFileFilter
implements FileFilter {
    private boolean acceptFiles;
    private boolean acceptDirectories;
    private Set<String> acceptExtensions;

    public BasicFileFilter() {
        this(true, true);
    }

    public BasicFileFilter(boolean bl, boolean bl2) {
        this.acceptFiles = bl;
        this.acceptDirectories = bl2;
    }

    public BasicFileFilter(boolean bl, boolean bl2, Set<String> set) {
        this.acceptFiles = bl;
        this.acceptDirectories = bl2;
        this.acceptExtensions = set;
    }

    @Override
    public boolean accept(File file) {
        return (file.isFile() && this.acceptFiles && this.acceptExtension(file) || file.isDirectory() && this.acceptDirectories) && !file.getName().startsWith(".svn");
    }

    private boolean acceptExtension(File file) {
        boolean bl = true;
        if (this.acceptExtensions != null) {
            bl = false;
            for (String string : this.acceptExtensions) {
                if (!file.getName().endsWith(string)) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }
}

