/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.text;

import com.jronimo.collections.collection.CollectionUtils;
import com.jronimo.exceptions.ResourceTextNotFoundException;
import com.jronimo.exceptions.UnexpectedErrorException;
import com.jronimo.internationalization.Language;
import com.jronimo.internationalization.Languages;
import com.jronimo.text.ResourceTextIdentifiers;
import com.jronimo.text.ResourceTextPointer;
import com.jronimo.util.Assert;
import com.jronimo.util.FileMethods;
import com.jronimo.util.Logger;
import com.jronimo.util.Methods;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ResourceText {
    private static final Logger logger = Logger.getLogger(ResourceText.class);
    private static final String[] supportedLanguages = new String[]{"en", "en_British"};
    private static Language defaultLanguage;
    private static Language currentLanguage;
    private static Language currentLanguageVariation;
    private static Set<Class> registered;
    private static Set<Object> registeredKeys;
    private static Map<Language, Map<Object, String>> languageText;
    private static Map<Language, Map<Object, String>> languageVariationText;
    private static boolean currentLanguageSupported;
    private static boolean currentLanguageVariationSupported;

    private ResourceText() {
    }

    public static String getText(Object object) {
        return ResourceText.getText((LanguageDetails)null, object, null);
    }

    public static String getText(Object object, Object ... objectArray) {
        return ResourceText.getText((LanguageDetails)null, object, objectArray);
    }

    public static String getText(LanguageDetails languageDetails, Object object) {
        return ResourceText.getText(languageDetails, object, null);
    }

    public static String getText(LanguageDetails languageDetails, Object object, Object ... objectArray) {
        String string = null;
        Language language = null;
        language = languageDetails != null && languageDetails.hasLanguage() ? languageDetails.getLanguage() : (languageDetails == null || languageDetails.getLanguageCode() == null ? (currentLanguageVariation == null ? currentLanguage : currentLanguageVariation) : (languageDetails.getLanguageVariation() == null ? Languages.getInstance().getPrimary(languageDetails.getLanguageCode()) : Languages.getInstance().getVariation(languageDetails.getLanguageCode(), languageDetails.getLanguageVariation())));
        string = ResourceText.getText(language, object, objectArray);
        return string;
    }

    public static String getText(Language language, Object object) {
        return ResourceText.getText(language, object, null);
    }

    public static String getText(Language language, Object object, Object ... objectArray) {
        String string = null;
        Language language2 = null;
        Language language3 = null;
        Assert.errorParam(object == null, new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_NOT_BE_NULL, "textKey"));
        if (language == null) {
            language2 = currentLanguage;
            language3 = currentLanguageVariation;
        } else if (language.isVariation()) {
            language2 = language.getPrimaryLanguage();
            language3 = language;
        } else {
            language2 = language;
        }
        if (!registeredKeys.contains(object)) {
            throw new RuntimeException("Not found (" + object + ").");
        }
        Assert.errorParam(!registeredKeys.contains(object), new ResourceTextPointer((Object)ResourceTextIdentifiers.TEXT_KEY_NOT_FOUND, object.toString(), language3 == null ? language2.toString() : language3.toString()));
        string = ResourceText.getText(object, objectArray, language2, language3);
        return string;
    }

    private static String getText(Object object, Object[] objectArray, Language language, Language language2) {
        StringBuilder stringBuilder = null;
        String string = null;
        int n = 0;
        try {
            stringBuilder = new StringBuilder(ResourceText.getText(object, language, language2));
            if (!Methods.isEmpty(objectArray)) {
                int n2 = objectArray.length;
                for (int i = 0; i < n2; ++i) {
                    string = "{" + i + "}";
                    n = stringBuilder.indexOf(string);
                    if (n < 0) continue;
                    int n3 = string.length();
                    for (int j = 0; j < n3; ++j) {
                        stringBuilder.deleteCharAt(n);
                    }
                    stringBuilder.insert(n, objectArray[i]);
                }
            }
        }
        catch (UnexpectedErrorException unexpectedErrorException) {
            throw unexpectedErrorException;
        }
        catch (Exception exception) {
            throw new UnexpectedErrorException(exception);
        }
        return stringBuilder.toString();
    }

    private static synchronized String getText(Object object, Language language, Language language2) {
        Map map;
        String string = null;
        ArrayList<Map<Object, String>> arrayList = null;
        String string2 = null;
        arrayList = new ArrayList<Map<Object, String>>(3);
        if (language2 != null) {
            arrayList.add(ResourceText.getMap(language2, languageVariationText));
        }
        if (language != null) {
            arrayList.add(ResourceText.getMap(language, languageText));
        }
        if (currentLanguageVariation != null && !currentLanguageVariation.equals(language2)) {
            arrayList.add(ResourceText.getMap(currentLanguageVariation, languageVariationText));
        }
        if (!currentLanguage.equals(language)) {
            arrayList.add(ResourceText.getMap(currentLanguage, languageText));
        }
        if (!defaultLanguage.equals(currentLanguage) && !defaultLanguage.equals(language)) {
            arrayList.add(ResourceText.getMap(defaultLanguage, languageText));
        }
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext() && (string = (String)(map = (Map)iterator.next()).get(object)) == null) {
        }
        if (string == null) {
            string2 = "Text not found (" + object + ")";
            throw new ResourceTextNotFoundException(string2);
        }
        return string;
    }

    private static void register(String string) {
        try {
            ResourceText.register(Class.forName(string));
        }
        catch (Exception exception) {
            logger.error(exception);
        }
    }

    public static void register(Class clazz) {
        if (!registered.contains(clazz)) {
            registered.add(clazz);
            try {
                ResourceText.registerInternal(clazz);
            }
            catch (Exception exception) {
                logger.error(exception);
            }
        }
    }

    private static void registerInternal(Class clazz) throws Exception {
        Collection collection = null;
        HashSet<Language> hashSet = null;
        Map<Object, String> map = null;
        String string = null;
        String string2 = null;
        collection = ResourceText.getEnumElements(clazz);
        hashSet = new HashSet<Language>(2);
        hashSet.add(defaultLanguage);
        hashSet.add(currentLanguage);
        if (currentLanguageVariation != null) {
            hashSet.add(currentLanguageVariation);
        }
        for (String string3 : supportedLanguages) {
            string = ResourceText.getLanguageCode(string3);
            string2 = ResourceText.getLanguageVariation(string3);
            hashSet.add(Languages.getInstance().getPrimary(string));
            if (string2 == null) continue;
            hashSet.add(Languages.getInstance().getVariation(string, string2));
        }
        for (Language language : hashSet) {
            map = language.isVariation() ? ResourceText.getMap(language, languageVariationText) : ResourceText.getMap(language, languageText);
            ResourceText.loadText(clazz, collection, "ResourceText-" + language.toString() + ".properties", map);
        }
        for (Object e : collection) {
            registeredKeys.add(e);
        }
    }

    private static void loadText(Class clazz, Collection collection, String string, Map<Object, String> map) throws Exception {
        List<String> list = null;
        String string2 = null;
        int n = 0;
        String string3 = null;
        list = FileMethods.readTextFileLines(clazz, string, true);
        if (list != null && list.size() > 0) {
            for (Object e : collection) {
                string2 = ResourceText.getLine(list, e.toString());
                if (string2 == null) continue;
                n = string2.indexOf("=");
                string3 = n + 1 < string2.length() ? string2.substring(n + 1) : "";
                map.put(e, string3);
            }
        }
    }

    private static String getLine(Collection<String> collection, String string) {
        String string2 = null;
        string = string + "=";
        for (String string3 : collection) {
            if (!string3.startsWith(string)) continue;
            string2 = string3;
            break;
        }
        return string2;
    }

    private static Collection getEnumElements(Class clazz) throws Exception {
        Set set = null;
        set = CollectionUtils.arrayToSet(clazz.getEnumConstants());
        return set;
    }

    private static Map<Object, String> getMap(Language language, Map<Language, Map<Object, String>> map) {
        Map<Object, String> map2 = null;
        map2 = map.get(language);
        if (map2 == null) {
            map2 = new HashMap<Object, String>();
            map.put(language, map2);
        }
        return map2;
    }

    private static String getLanguageCode(String string) {
        String string2 = null;
        int n = 0;
        n = string.indexOf("_");
        string2 = n >= 0 ? string.substring(0, n) : string;
        return string2;
    }

    private static String getLanguageVariation(String string) {
        String string2 = null;
        int n = 0;
        n = string.indexOf("_");
        if (n >= 0) {
            string2 = string.substring(n + 1);
        }
        return string2;
    }

    static {
        registered = new HashSet<Class>();
        registeredKeys = new HashSet<Object>();
        languageText = new HashMap<Language, Map<Object, String>>();
        languageVariationText = new HashMap<Language, Map<Object, String>>();
        defaultLanguage = Languages.getInstance().getPrimary("en");
        currentLanguage = Languages.getInstance().getPrimary(Locale.getDefault());
        currentLanguageVariation = Languages.getInstance().getVariation(Locale.getDefault());
        if (currentLanguage != null) {
            for (String string : supportedLanguages) {
                if (!string.equals(currentLanguage.toString())) continue;
                currentLanguageSupported = true;
                break;
            }
        }
        if (currentLanguageVariation != null) {
            for (String string : supportedLanguages) {
                if (!string.equals(currentLanguageVariation.toString())) continue;
                currentLanguageVariationSupported = true;
                break;
            }
        }
        if (!currentLanguageSupported) {
            currentLanguage = defaultLanguage;
        }
        if (!currentLanguageVariationSupported) {
            currentLanguageVariation = null;
        }
        ResourceText.register(ResourceTextIdentifiers.class);
        ResourceText.register("com.jronimo.collections.text.ResourceTextIdentifiers");
        ResourceText.register("com.jronimo.xml.ResourceTextIdentifiers");
        ResourceText.register("com.jronimo.temporal.ResourceTextIdentifiers");
        ResourceText.register("com.jronimo.constraints.ResourceTextIdentifiers");
        ResourceText.register("com.jronimo.systemconfiguration.ResourceTextIdentifiers");
        ResourceText.register("com.jronimo.engines.dataservice.ResourceTextIdentifiers");
        ResourceText.register("com.jronimo.engines.dataservice.exceptions.ResourceTextIdentifiers");
        ResourceText.register("com.jronimo.webappengines.ResourceTextIdentifiers");
        ResourceText.register("com.jronimo.webappengines.exceptions.ResourceTextIdentifiers");
        ResourceText.register("com.jronimo.webappengines.core.exceptions.ResourceTextIdentifiers");
        ResourceText.register("com.jronimo.documenter.ResourceTextIdentifiers");
    }

    public static class LanguageDetails {
        private Language language;
        private String languageCode;
        private String languageVariation;

        public LanguageDetails(Language language) {
            this.language = language;
        }

        public LanguageDetails(String string) {
            this.languageCode = string;
        }

        public LanguageDetails(String string, String string2) {
            this.languageCode = string;
            this.languageVariation = string2;
        }

        public boolean hasLanguage() {
            return this.language != null;
        }

        public Language getLanguage() {
            return this.language;
        }

        public String getLanguageCode() {
            return this.languageCode;
        }

        public String getLanguageVariation() {
            return this.languageVariation;
        }
    }
}

