/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.temporal;

import com.jronimo.internationalization.Language;
import com.jronimo.temporal.ResourceTextIdentifiers;
import com.jronimo.temporal.TimezoneLoader;
import com.jronimo.text.ResourceTextPointer;
import com.jronimo.util.Assert;
import com.jronimo.util.Logger;
import java.util.Calendar;
import java.util.Map;
import java.util.TimeZone;

public final class Timezone {
    private static final Logger logger = Logger.getLogger(Timezone.class);
    private static Map<Integer, Timezone> timezones;
    private static boolean loaded;
    private int id;
    private String labelText;
    private String javaId;

    Timezone(int n, String string, String string2) {
        this.id = n;
        this.labelText = string;
        this.javaId = string2;
    }

    public static synchronized void load() {
        if (!loaded) {
            try {
                timezones = TimezoneLoader.execute();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            loaded = true;
        }
    }

    public static Timezone getTimezone(int n) {
        return timezones.get(n);
    }

    public static Timezone getTimezone(int n, boolean bl) {
        Timezone timezone = null;
        timezone = timezones.get(n);
        if (timezone == null && bl) {
            logger.warning(new ResourceTextPointer((Object)ResourceTextIdentifiers.UNRECOGNIZED_TIMEZONE_ID, String.valueOf(n)).getText());
            timezone = timezones.get(0);
        }
        return timezone;
    }

    public static Timezone getTimezone(String string) {
        Timezone timezone = null;
        string = string.toUpperCase();
        for (Timezone timezone2 : timezones.values()) {
            if (timezone2.getLabelText().toUpperCase().indexOf(string) < 0) continue;
            timezone = timezone2;
            break;
        }
        return timezone;
    }

    public static Timezone getTimezoneByJavaId(String string) {
        Timezone timezone = null;
        String string2 = null;
        boolean bl = false;
        TimeZone timeZone = null;
        string2 = string.toUpperCase();
        for (Timezone timezone2 : timezones.values()) {
            if (timezone2.getJavaId().toUpperCase().indexOf(string2) < 0) continue;
            timezone = timezone2;
            break;
        }
        if (timezone == null) {
            for (String string3 : TimeZone.getAvailableIDs()) {
                if (!string3.equals(string)) continue;
                bl = true;
                break;
            }
            Assert.errorParam(!bl, new ResourceTextPointer((Object)ResourceTextIdentifiers.UNRECOGNIZED_JAVA_TIMEZONE_ID, "javaId"));
            timeZone = TimeZone.getTimeZone(string);
            for (Timezone timezone3 : timezones.values()) {
                if (timeZone.getRawOffset() != timezone3.getJavaTimeZone().getRawOffset()) continue;
                timezone = timezone3;
                break;
            }
        }
        return timezone;
    }

    public int getId() {
        return this.id;
    }

    public String getLabelText() {
        return this.labelText;
    }

    public String getJavaId() {
        return this.javaId;
    }

    public synchronized String getText() {
        return this.getText(null);
    }

    public synchronized String getText(Language language) {
        String string = null;
        string = new ResourceTextPointer((Object)ResourceTextIdentifiers.valueOf("TIMEZONE_" + this.id), language).getText();
        return string;
    }

    public int getOffsetAdjustment(Calendar calendar) {
        int n = 0;
        Assert.errorParam(calendar == null, new ResourceTextPointer((Object)com.jronimo.text.ResourceTextIdentifiers.MUST_NOT_BE_NULL, "calendar"));
        n = this.getJavaTimeZone().getOffset(calendar.getTime().getTime());
        return n;
    }

    public TimeZone getJavaTimeZone() {
        return TimeZone.getTimeZone(this.javaId);
    }

    public int hashCode() {
        return this.id;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        Timezone timezone = null;
        if (object instanceof Timezone) {
            timezone = (Timezone)object;
            bl = this.id == timezone.id;
        }
        return bl;
    }

    public String toString() {
        return this.id + " \"" + this.getText() + "\" \"" + this.javaId + "\"";
    }

    static {
        Timezone.load();
    }
}

