/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.temporal;

import com.jronimo.collections.NullFreeMutableList;
import com.jronimo.temporal.Constants;
import com.jronimo.temporal.DateTime;
import com.jronimo.temporal.ResourceTextIdentifiers;
import com.jronimo.temporal.StringFormat;
import com.jronimo.temporal.TemporalUtils;
import com.jronimo.temporal.Time;
import com.jronimo.temporal.Timezone;
import com.jronimo.temporal.ValueStruct;
import com.jronimo.text.ResourceText;
import com.jronimo.text.ResourceTextPointer;
import com.jronimo.util.Assert;
import com.jronimo.util.Logger;
import com.jronimo.util.StringWrapperWithVoidRegions;
import java.util.Calendar;
import java.util.Comparator;

public final class TimeOfDay
implements Comparable {
    private static final Logger logger = Logger.getLogger(TimeOfDay.class);
    private Time time;
    private Timezone timezone;
    private boolean hasExplicitTimezone;
    private TimeOfDay utcZeroInstance;

    public TimeOfDay(String string) {
        this(new ValueStruct(string));
    }

    public TimeOfDay(String string, Integer n) {
        this(new ValueStruct(string, n));
    }

    public TimeOfDay(ValueStruct valueStruct) {
        Assert.errorParam(valueStruct == null, new ResourceTextPointer((Object)com.jronimo.text.ResourceTextIdentifiers.MUST_NOT_BE_NULL, "struct"));
        valueStruct = this.ratifyStruct(valueStruct);
        this.time = new Time(valueStruct);
        this.timezone = TemporalUtils.getTimezone(valueStruct);
        this.hasExplicitTimezone = valueStruct.isExplicitTimezone;
        this.ratifyParts();
    }

    private ValueStruct ratifyStruct(ValueStruct valueStruct) {
        ValueStruct valueStruct2 = null;
        NullFreeMutableList<String> nullFreeMutableList = null;
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        valueStruct2 = valueStruct.clone();
        valueStruct2.isTimeOfDay = true;
        if (valueStruct2.stringValue != null) {
            nullFreeMutableList = new StringWrapperWithVoidRegions(valueStruct2.stringValue).split(" ");
            if (!nullFreeMutableList.isEmpty()) {
                string = (String)nullFreeMutableList.getFirst();
            }
            if (string != null && string.startsWith("-")) {
                string2 = ResourceText.getText((Object)ResourceTextIdentifiers.VALUE_CANNOT_BE_NEGATIVE);
            }
        } else if (valueStruct2.temporalValue != null) {
            if (valueStruct2.temporalValue < 0L) {
                string3 = ResourceText.getText((Object)ResourceTextIdentifiers.VALUE_CANNOT_BE_NEGATIVE);
            } else if (valueStruct2.temporalValue > 235959999L) {
                string3 = ResourceText.getText((Object)ResourceTextIdentifiers.VALUE_CANNOT_BE_GREATER_THAN, (Object[])new String[]{"235959999"});
            }
        } else if (valueStruct2.millisecondValue != null) {
            if (valueStruct2.millisecondValue < 0L) {
                string4 = ResourceText.getText((Object)ResourceTextIdentifiers.VALUE_CANNOT_BE_NEGATIVE);
            } else if (valueStruct2.millisecondValue > 86399999L) {
                string4 = ResourceText.getText((Object)ResourceTextIdentifiers.VALUE_CANNOT_BE_GREATER_THAN_MILLI_DAY);
            }
        }
        if (string2 != null) {
            throw new IllegalArgumentException(ResourceText.getText((Object)ResourceTextIdentifiers.INVALID_STRING_VALUE, (Object[])new String[]{valueStruct2.stringValue, "TimeOfDay", string2}));
        }
        if (string3 != null) {
            throw new IllegalArgumentException(ResourceText.getText((Object)ResourceTextIdentifiers.INVALID_TEMPORAL_VALUE, (Object[])new String[]{String.valueOf(valueStruct2.temporalValue), "TimeOfDay", string3}));
        }
        if (string4 != null) {
            throw new IllegalArgumentException(ResourceText.getText((Object)ResourceTextIdentifiers.INVALID_MILLISECOND_VALUE, (Object[])new String[]{String.valueOf(valueStruct2.millisecondValue), "TimeOfDay", string4}));
        }
        return valueStruct2;
    }

    private void ratifyParts() {
        if (this.time.getHour() < 0L || this.time.getHour() > 23L) {
            throw new IllegalArgumentException(ResourceText.getText((Object)ResourceTextIdentifiers.INVALID_NUMBER_OF_HOURS, (Object[])new String[]{String.valueOf(this.time.getHour())}));
        }
    }

    public String getString(StringFormat stringFormat) {
        StringBuilder stringBuilder = null;
        stringFormat = stringFormat == null ? new StringFormat() : stringFormat.clone();
        stringFormat.setTimeFormatIfNull(new StringFormat.TimeFormat(true));
        stringFormat.setTimezoneFormatIfNull(new StringFormat.TimezoneFormat(this.hasExplicitTimezone));
        if (stringFormat.getTimeFormat().includeTime()) {
            stringFormat.getTimeFormat().setTimeFormatIfNull(Constants.TimeFormat.HHMMSSMMM);
            stringFormat.getTimeFormat().setPadHour(true);
        }
        stringFormat.getTimezoneFormat().setIncludeTimezoneIdIfNull(false);
        stringFormat.getTimezoneFormat().setIncludeTimezoneNameIfNull(false);
        stringBuilder = new StringBuilder(this.time.getString(stringFormat));
        if (stringFormat.getTimezoneFormat().includeTimezone().booleanValue()) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(" ");
            }
            if (stringFormat.getTimezoneFormat().includeTimezoneName().booleanValue()) {
                stringBuilder.append(this.timezone.getText());
            } else if (stringFormat.getTimezoneFormat().includeTimezoneId().booleanValue()) {
                stringBuilder.append(this.timezone.getId());
            }
        }
        return stringBuilder.toString();
    }

    public long getTemporalValue() {
        return this.time.getTemporalValue();
    }

    public long getMillisecondValue() {
        return this.time.getMillisecondValue();
    }

    public byte getHour() {
        return (byte)this.time.getHour();
    }

    public byte getMinute() {
        return this.time.getMinute();
    }

    public byte getSecond() {
        return this.time.getSecond();
    }

    public short getMillisecond() {
        return this.time.getMillisecond();
    }

    public Timezone getTimezone() {
        return this.timezone;
    }

    public boolean hasExplicitTimezone() {
        return this.hasExplicitTimezone;
    }

    public synchronized TimeOfDay getUtcZeroInstance() {
        DateTime dateTime = null;
        if (this.utcZeroInstance == null) {
            dateTime = new DateTime("0001-06-01 " + this.time.toString(), this.hasExplicitTimezone ? Integer.valueOf(0) : null);
            dateTime = DateTime.addMilliseconds(dateTime, -1 * this.timezone.getOffsetAdjustment(dateTime.getCalendar()));
            this.utcZeroInstance = dateTime.getTime();
        }
        return this.utcZeroInstance;
    }

    public boolean equalTo(TimeOfDay timeOfDay, boolean bl) {
        return bl ? TimeOfDay.compareWithTimezones(this, timeOfDay) == 0 : TimeOfDay.compareWithoutTimezones(this, timeOfDay) == 0;
    }

    public boolean lessThan(TimeOfDay timeOfDay, boolean bl) {
        return bl ? TimeOfDay.compareWithTimezones(this, timeOfDay) < 0 : TimeOfDay.compareWithoutTimezones(this, timeOfDay) < 0;
    }

    public boolean lessThanOrEqualTo(TimeOfDay timeOfDay, boolean bl) {
        return bl ? TimeOfDay.compareWithTimezones(this, timeOfDay) <= 0 : TimeOfDay.compareWithoutTimezones(this, timeOfDay) <= 0;
    }

    public boolean greaterThan(TimeOfDay timeOfDay, boolean bl) {
        return bl ? TimeOfDay.compareWithTimezones(this, timeOfDay) > 0 : TimeOfDay.compareWithoutTimezones(this, timeOfDay) > 0;
    }

    public boolean greaterThanOrEqualTo(TimeOfDay timeOfDay, boolean bl) {
        return bl ? TimeOfDay.compareWithTimezones(this, timeOfDay) >= 0 : TimeOfDay.compareWithoutTimezones(this, timeOfDay) >= 0;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public Time difference(TimeOfDay timeOfDay, boolean bl) {
        Time time = null;
        DateTime dateTime = null;
        DateTime dateTime2 = null;
        Assert.errorParam(timeOfDay == null, new ResourceTextPointer((Object)com.jronimo.text.ResourceTextIdentifiers.MUST_NOT_BE_NULL, "instance"));
        dateTime = new DateTime("0001-06-01 " + this.toString());
        dateTime2 = new DateTime("0001-06-01 " + timeOfDay.toString());
        time = dateTime.difference(dateTime2, bl);
        return time;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        TimeOfDay timeOfDay = null;
        if (object instanceof TimeOfDay) {
            timeOfDay = (TimeOfDay)object;
            if (this.getTemporalValue() == timeOfDay.getTemporalValue() && this.timezone.equals(timeOfDay.timezone)) {
                bl = true;
            }
        }
        return bl;
    }

    public String toString() {
        return this.getString(null);
    }

    public int compareTo(Object object) {
        int n = 0;
        TimeOfDay timeOfDay = null;
        if (object instanceof TimeOfDay) {
            timeOfDay = (TimeOfDay)object;
            n = this.hasExplicitTimezone() && timeOfDay.hasExplicitTimezone() ? TimeOfDay.compareWithTimezones(this, timeOfDay) : TimeOfDay.compareWithoutTimezones(this, timeOfDay);
        } else {
            n = 1;
        }
        return n;
    }

    private static int compareWithoutTimezones(TimeOfDay timeOfDay, TimeOfDay timeOfDay2) {
        int n = 0;
        if (timeOfDay == null && timeOfDay2 != null) {
            n = -1;
        } else if (timeOfDay != null && timeOfDay2 == null) {
            n = 1;
        } else if (timeOfDay == null && timeOfDay2 == null) {
            n = 0;
        } else if (timeOfDay.getMillisecondValue() < timeOfDay2.getMillisecondValue()) {
            n = -1;
        } else if (timeOfDay.getMillisecondValue() > timeOfDay2.getMillisecondValue()) {
            n = 1;
        }
        return n;
    }

    private static int compareWithTimezones(TimeOfDay timeOfDay, TimeOfDay timeOfDay2) {
        int n = 0;
        if (timeOfDay == null && timeOfDay2 != null) {
            n = -1;
        } else if (timeOfDay != null && timeOfDay2 == null) {
            n = 1;
        } else if (timeOfDay == null && timeOfDay2 == null) {
            n = 0;
        } else {
            timeOfDay = new DateTime("0001-06-01 " + timeOfDay.toString()).getUtcZeroInstance().getTime();
            timeOfDay2 = new DateTime("0001-06-01 " + timeOfDay2.toString()).getUtcZeroInstance().getTime();
            n = TimeOfDay.compareWithoutTimezones(timeOfDay, timeOfDay2);
        }
        return n;
    }

    public static TimeOfDay now(boolean bl) {
        return TimeOfDay.now(bl, null);
    }

    public static TimeOfDay now(boolean bl, Integer n) {
        TimeOfDay timeOfDay = null;
        int n2 = 0;
        if (bl) {
            n2 = Timezone.getTimezoneByJavaId(Calendar.getInstance().getTimeZone().getID()).getId();
        }
        if (n == null) {
            n = n2;
        }
        timeOfDay = TimeOfDay.now(n2, n);
        return timeOfDay;
    }

    public static TimeOfDay now(int n) {
        return TimeOfDay.now(n, null);
    }

    public static TimeOfDay now(int n, Integer n2) {
        TimeOfDay timeOfDay = null;
        Timezone timezone = null;
        StringBuilder stringBuilder = null;
        Calendar calendar = null;
        Object var6_6 = null;
        timezone = Timezone.getTimezone(n);
        Assert.errorParam(timezone == null, new ResourceTextPointer((Object)com.jronimo.text.ResourceTextIdentifiers.UNRECOGNIZED_VALUE, "nowTimezoneId", String.valueOf(n)));
        if (n2 == null) {
            n2 = n;
        }
        stringBuilder = new StringBuilder();
        calendar = Calendar.getInstance(timezone.getJavaTimeZone());
        stringBuilder.append(calendar.get(11));
        stringBuilder.append(":");
        stringBuilder.append(calendar.get(12));
        stringBuilder.append(":");
        stringBuilder.append(calendar.get(13));
        stringBuilder.append(".");
        stringBuilder.append(calendar.get(14));
        stringBuilder.append(" ");
        stringBuilder.append(n2);
        timeOfDay = new TimeOfDay(stringBuilder.toString());
        return timeOfDay;
    }

    public static TimeOfDay addHours(TimeOfDay timeOfDay, long l) {
        return TimeOfDay.addMilliseconds(timeOfDay, l * 1000L * 60L * 60L);
    }

    public static TimeOfDay addMinutes(TimeOfDay timeOfDay, long l) {
        return TimeOfDay.addMilliseconds(timeOfDay, l * 1000L * 60L);
    }

    public static TimeOfDay addSeconds(TimeOfDay timeOfDay, long l) {
        return TimeOfDay.addMilliseconds(timeOfDay, l * 1000L);
    }

    public static TimeOfDay addMilliseconds(TimeOfDay timeOfDay, long l) {
        TimeOfDay timeOfDay2 = null;
        timeOfDay2 = DateTime.addMilliseconds(new DateTime("0001-06-01 " + timeOfDay.toString()), l %= (long)Constants.UnitOfTime.DAY.getMilliseconds()).getTime();
        return timeOfDay2;
    }

    public static class WithTimezoneAdjustmentComparator
    implements Comparator {
        public int compare(Object object, Object object2) {
            int n = 0;
            n = object instanceof TimeOfDay && !(object2 instanceof TimeOfDay) ? 1 : (!(object instanceof TimeOfDay) && object2 instanceof TimeOfDay ? -1 : (!(object instanceof TimeOfDay) && !(object2 instanceof TimeOfDay) ? 0 : TimeOfDay.compareWithTimezones((TimeOfDay)object, (TimeOfDay)object2)));
            return n;
        }
    }

    public static class WithoutTimezoneAdjustmentComparator
    implements Comparator {
        public int compare(Object object, Object object2) {
            int n = 0;
            n = object instanceof TimeOfDay && !(object2 instanceof TimeOfDay) ? 1 : (!(object instanceof TimeOfDay) && object2 instanceof TimeOfDay ? -1 : (!(object instanceof TimeOfDay) && !(object2 instanceof TimeOfDay) ? 0 : TimeOfDay.compareWithoutTimezones((TimeOfDay)object, (TimeOfDay)object2)));
            return n;
        }
    }
}

