/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.temporal;

import com.jronimo.temporal.Constants;

public final class StringFormat {
    private DateFormat dateFormat;
    private TimeFormat timeFormat;
    private TimezoneFormat timezoneFormat;

    public StringFormat() {
    }

    public StringFormat(DateFormat dateFormat) {
        this.dateFormat = dateFormat;
    }

    public StringFormat(DateFormat dateFormat, TimezoneFormat timezoneFormat) {
        this.dateFormat = dateFormat;
        this.timezoneFormat = timezoneFormat;
    }

    public StringFormat(TimeFormat timeFormat) {
        this.timeFormat = timeFormat;
    }

    public StringFormat(TimeFormat timeFormat, TimezoneFormat timezoneFormat) {
        this.timeFormat = timeFormat;
        this.timezoneFormat = timezoneFormat;
    }

    public StringFormat(DateFormat dateFormat, TimeFormat timeFormat) {
        this.dateFormat = dateFormat;
        this.timeFormat = timeFormat;
    }

    public StringFormat(DateFormat dateFormat, TimeFormat timeFormat, TimezoneFormat timezoneFormat) {
        this.dateFormat = dateFormat;
        this.timeFormat = timeFormat;
        this.timezoneFormat = timezoneFormat;
    }

    public StringFormat(TimezoneFormat timezoneFormat) {
        this.timezoneFormat = timezoneFormat;
    }

    public DateFormat getDateFormat() {
        return this.dateFormat;
    }

    public TimeFormat getTimeFormat() {
        return this.timeFormat;
    }

    public TimezoneFormat getTimezoneFormat() {
        return this.timezoneFormat;
    }

    public void setDateFormatIfNull(DateFormat dateFormat) {
        if (this.dateFormat == null) {
            this.dateFormat = dateFormat;
        }
    }

    public void setTimeFormatIfNull(TimeFormat timeFormat) {
        if (this.timeFormat == null) {
            this.timeFormat = timeFormat;
        }
    }

    public void setTimezoneFormatIfNull(TimezoneFormat timezoneFormat) {
        if (this.timezoneFormat == null) {
            this.timezoneFormat = timezoneFormat;
        }
    }

    public StringFormat clone() {
        StringFormat stringFormat = null;
        stringFormat = new StringFormat();
        if (this.dateFormat != null) {
            stringFormat.dateFormat = this.dateFormat.typeClone();
        }
        if (this.timeFormat != null) {
            stringFormat.timeFormat = this.timeFormat.typeClone();
        }
        if (this.timezoneFormat != null) {
            stringFormat.timezoneFormat = this.timezoneFormat.typeClone();
        }
        return stringFormat;
    }

    public static class TimezoneFormat {
        private Boolean includeTimezoneId;
        private Boolean includeTimezoneName;

        public TimezoneFormat() {
        }

        public TimezoneFormat(Boolean bl) {
            this.includeTimezoneId = bl;
        }

        public TimezoneFormat(Boolean bl, Boolean bl2) {
            this.includeTimezoneId = bl;
            this.includeTimezoneName = bl2;
        }

        public Boolean includeTimezone() {
            return this.includeTimezoneId() != false || this.includeTimezoneName() != false;
        }

        public Boolean includeTimezoneId() {
            return this.includeTimezoneId == null ? false : this.includeTimezoneId;
        }

        public Boolean includeTimezoneName() {
            return this.includeTimezoneName == null ? false : this.includeTimezoneName;
        }

        public void setIncludeTimezoneIdIfNull(Boolean bl) {
            if (this.includeTimezoneId == null) {
                this.includeTimezoneId = bl;
            }
        }

        public void setIncludeTimezoneNameIfNull(Boolean bl) {
            if (this.includeTimezoneName == null) {
                this.includeTimezoneName = bl;
            }
        }

        public Object clone() {
            return this.typeClone();
        }

        public TimezoneFormat typeClone() {
            return new TimezoneFormat(this.includeTimezoneId, this.includeTimezoneName);
        }
    }

    public static class TimeFormat {
        private boolean includeTime;
        private Constants.TimeFormat timeFormat;
        private Constants.TimeSeparator separator;
        private Boolean includeLeadingSpace;
        private Boolean padHour;

        public TimeFormat(boolean bl) {
            this.includeTime = bl;
        }

        public boolean includeTime() {
            return this.includeTime;
        }

        public Constants.TimeFormat getTimeFormat() {
            return this.timeFormat;
        }

        public Constants.TimeSeparator getSeparator() {
            return this.separator;
        }

        public Boolean includeLeadingSpace() {
            return this.includeLeadingSpace;
        }

        public void setTimeFormatIfNull(Constants.TimeFormat timeFormat) {
            if (this.timeFormat == null) {
                this.timeFormat = timeFormat;
            }
        }

        public void setSeparatorIfNull(Constants.TimeSeparator timeSeparator) {
            if (this.separator == null) {
                this.separator = timeSeparator;
            }
        }

        public void setIncludeLeadingSpaceIfNull(Boolean bl) {
            if (this.includeLeadingSpace == null) {
                this.includeLeadingSpace = bl;
            }
        }

        void setPadHour(Boolean bl) {
            this.padHour = bl;
        }

        Boolean getPadHour() {
            return this.padHour;
        }

        public Object clone() {
            return this.typeClone();
        }

        public TimeFormat typeClone() {
            TimeFormat timeFormat = null;
            timeFormat = new TimeFormat(this.includeTime);
            timeFormat.timeFormat = this.timeFormat;
            timeFormat.separator = this.separator;
            timeFormat.includeLeadingSpace = this.includeLeadingSpace;
            timeFormat.padHour = this.padHour;
            return timeFormat;
        }
    }

    public static class DateFormat {
        private boolean includeDate;
        private Constants.DateSeparator separator;
        private Boolean useAdBc;
        private Constants.MonthFormat monthFormat;

        public DateFormat(boolean bl) {
            this.includeDate = bl;
        }

        public boolean includeDate() {
            return this.includeDate;
        }

        public Constants.DateSeparator getSeparator() {
            return this.separator;
        }

        public Boolean useAdBc() {
            return this.useAdBc;
        }

        public Constants.MonthFormat getMonthFormat() {
            return this.monthFormat;
        }

        public void setSeparatorIfNull(Constants.DateSeparator dateSeparator) {
            if (this.separator == null) {
                this.separator = dateSeparator;
            }
        }

        public void setUseAdBcIfNull(Boolean bl) {
            if (this.useAdBc == null) {
                this.useAdBc = bl;
            }
        }

        public void setMonthFormatIfNull(Constants.MonthFormat monthFormat) {
            if (this.monthFormat == null) {
                this.monthFormat = monthFormat;
            }
        }

        public Object clone() {
            return this.typeClone();
        }

        public DateFormat typeClone() {
            DateFormat dateFormat = null;
            dateFormat = new DateFormat(this.includeDate);
            dateFormat.separator = this.separator;
            dateFormat.useAdBc = this.useAdBc;
            dateFormat.monthFormat = this.monthFormat;
            return dateFormat;
        }
    }
}

