/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.temporal;

import com.jronimo.temporal.DateTime;
import com.jronimo.temporal.Timezone;
import com.jronimo.text.ResourceTextIdentifiers;
import com.jronimo.text.ResourceTextPointer;
import com.jronimo.util.Assert;
import java.util.Comparator;

public class DateTimeRange
implements Comparable {
    private DateTime startDate;
    private DateTime endDate;
    private boolean hasExplicitTimezone;

    public DateTimeRange(DateTime dateTime, DateTime dateTime2, Integer n) {
        DateTime dateTime3 = null;
        if (n == null) {
            this.hasExplicitTimezone = false;
            n = 0;
        } else {
            this.hasExplicitTimezone = true;
        }
        Assert.errorParam(Timezone.getTimezone(n) == null, new ResourceTextPointer((Object)ResourceTextIdentifiers.UNRECOGNIZED_VALUE, "timezoneId", String.valueOf(n)));
        this.startDate = dateTime == null || dateTime.getTimezone().getId() == n.intValue() ? dateTime : new DateTime(dateTime.getTemporalValue(), n);
        this.endDate = dateTime2 == null || dateTime2.getTimezone().getId() == n.intValue() ? dateTime2 : new DateTime(dateTime2.getTemporalValue(), n);
        if (this.startDate != null && this.endDate != null && this.endDate.lessThan(this.startDate, false)) {
            dateTime3 = this.startDate;
            this.startDate = this.endDate;
            this.endDate = dateTime3;
        }
    }

    public DateTime getStartDate() {
        return this.startDate;
    }

    public DateTime getEndDate() {
        return this.endDate;
    }

    public boolean encompasses(DateTime dateTime, boolean bl) {
        boolean bl2 = false;
        Assert.errorParam(dateTime == null, new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_NOT_BE_NULL, "date"));
        bl2 = !DateTimeRange.before(dateTime, this.startDate, bl) && !DateTimeRange.after(dateTime, this.endDate, bl);
        return bl2;
    }

    public boolean encompasses(DateTimeRange dateTimeRange, boolean bl) {
        boolean bl2 = false;
        Assert.errorParam(dateTimeRange == null, new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_NOT_BE_NULL, "dateRange"));
        bl2 = DateTimeRange.encompasses(this, dateTimeRange.startDate, true, bl) && DateTimeRange.encompasses(this, dateTimeRange.endDate, false, bl);
        return bl2;
    }

    public boolean encompassedBy(DateTimeRange dateTimeRange, boolean bl) {
        return dateTimeRange.encompasses(this, bl);
    }

    public boolean overlappedLeftBy(DateTimeRange dateTimeRange, boolean bl) {
        boolean bl2 = false;
        Assert.errorParam(dateTimeRange == null, new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_NOT_BE_NULL, "dateRange"));
        bl2 = DateTimeRange.before(dateTimeRange.startDate, this.startDate, bl) && DateTimeRange.encompasses(this, dateTimeRange.endDate, false, bl);
        return bl2;
    }

    public boolean overlappedRightBy(DateTimeRange dateTimeRange, boolean bl) {
        boolean bl2 = false;
        Assert.errorParam(dateTimeRange == null, new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_NOT_BE_NULL, "dateRange"));
        bl2 = DateTimeRange.encompasses(this, dateTimeRange.startDate, true, bl) && DateTimeRange.after(dateTimeRange.endDate, this.endDate, bl);
        return bl2;
    }

    public boolean overlappedBy(DateTimeRange dateTimeRange, boolean bl) {
        return this.overlappedLeftBy(dateTimeRange, bl) || this.overlappedRightBy(dateTimeRange, bl);
    }

    public boolean before(DateTimeRange dateTimeRange, boolean bl) {
        boolean bl2 = false;
        Assert.errorParam(dateTimeRange == null, new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_NOT_BE_NULL, "dateRange"));
        bl2 = this.endDate != null && dateTimeRange.startDate != null && this.endDate.lessThan(dateTimeRange.startDate, bl);
        return bl2;
    }

    public boolean after(DateTimeRange dateTimeRange, boolean bl) {
        boolean bl2 = false;
        Assert.errorParam(dateTimeRange == null, new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_NOT_BE_NULL, "dateRange"));
        bl2 = this.startDate != null && dateTimeRange.endDate != null && this.startDate.greaterThan(dateTimeRange.endDate, bl);
        return bl2;
    }

    public int hashCode() {
        int n = 17;
        if (this.startDate == null && this.endDate == null) {
            n = String.valueOf(System.currentTimeMillis()).hashCode();
        } else {
            if (this.startDate != null) {
                n = n * 37 + this.startDate.hashCode();
            }
            if (this.endDate != null) {
                n = n * 37 + this.endDate.hashCode();
            }
        }
        return n;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        DateTimeRange dateTimeRange = null;
        if (object instanceof DateTimeRange) {
            dateTimeRange = (DateTimeRange)object;
            bl = (this.startDate == null && dateTimeRange.startDate == null || this.startDate != null && this.startDate.equals(dateTimeRange.startDate)) && (this.endDate == null && dateTimeRange.endDate == null || this.endDate != null && this.endDate.equals(dateTimeRange.endDate));
        }
        return bl;
    }

    public int compareTo(Object object) {
        return DateTimeRange.compare(this, object, object instanceof DateTimeRange && this.hasExplicitTimezone && ((DateTimeRange)object).hasExplicitTimezone);
    }

    private static boolean encompasses(DateTimeRange dateTimeRange, DateTime dateTime, boolean bl, boolean bl2) {
        boolean bl3 = false;
        bl3 = dateTime == null ? (bl ? dateTimeRange.startDate == null : dateTimeRange.endDate == null) : !DateTimeRange.before(dateTime, dateTimeRange.startDate, bl2) && !DateTimeRange.after(dateTime, dateTimeRange.endDate, bl2);
        return bl3;
    }

    private static boolean before(DateTime dateTime, DateTime dateTime2, boolean bl) {
        return dateTime2 != null && (dateTime == null || dateTime.lessThan(dateTime2, bl));
    }

    private static boolean after(DateTime dateTime, DateTime dateTime2, boolean bl) {
        return dateTime2 != null && (dateTime == null || dateTime.greaterThan(dateTime2, bl));
    }

    private static int compare(Object object, Object object2, boolean bl) {
        int n = 0;
        Object var4_4 = null;
        Object var5_5 = null;
        if (object instanceof DateTimeRange && !(object2 instanceof DateTimeRange)) {
            n = 1;
        } else if (!(object instanceof DateTimeRange) && object2 instanceof DateTimeRange) {
            n = -1;
        } else if (!(object instanceof DateTimeRange) && !(object2 instanceof DateTimeRange)) {
            n = 0;
        } else if (DateTimeRange.before(var4_4.startDate, var5_5.startDate, bl)) {
            n = -1;
        } else if (DateTimeRange.before(var5_5.startDate, var4_4.startDate, bl)) {
            n = 1;
        } else if (DateTimeRange.after(var4_4.endDate, var5_5.endDate, bl)) {
            n = 1;
        } else if (DateTimeRange.after(var5_5.endDate, var4_4.endDate, bl)) {
            n = -1;
        }
        return n;
    }

    public static class WithTimezoneAdjustmentComparator
    implements Comparator {
        public int compare(Object object, Object object2) {
            return DateTimeRange.compare(object, object2, true);
        }
    }

    public static class WithoutTimezoneAdjustmentComparator
    implements Comparator {
        public int compare(Object object, Object object2) {
            return DateTimeRange.compare(object, object2, false);
        }
    }
}

