/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.temporal;

import com.jronimo.collections.NullFreeMutableList;
import com.jronimo.temporal.Constants;
import com.jronimo.temporal.Date;
import com.jronimo.temporal.PublicHolidayLookup;
import com.jronimo.temporal.ResourceTextIdentifiers;
import com.jronimo.temporal.StringFormat;
import com.jronimo.temporal.TemporalUtils;
import com.jronimo.temporal.Time;
import com.jronimo.temporal.TimeOfDay;
import com.jronimo.temporal.Timezone;
import com.jronimo.temporal.ValueStruct;
import com.jronimo.text.ResourceText;
import com.jronimo.text.ResourceTextPointer;
import com.jronimo.util.Assert;
import com.jronimo.util.Logger;
import com.jronimo.util.StringWrapper;
import java.util.Calendar;
import java.util.Comparator;

public final class DateTime
implements Comparable {
    private static final Logger logger = Logger.getLogger(DateTime.class);
    private Date date;
    private TimeOfDay time;
    private long temporalValue;
    private Calendar calendar;
    private DateTime utcZeroInstance;

    public DateTime(String string) {
        this(new ValueStruct(string));
    }

    public DateTime(String string, Integer n) {
        this(new ValueStruct(string, n));
    }

    public DateTime(long l) {
        this(new ValueStruct(l));
    }

    public DateTime(long l, Integer n) {
        this(new ValueStruct(l, n));
    }

    public DateTime(int n) {
        this(new ValueStruct(n));
    }

    public DateTime(int n, Integer n2) {
        this(new ValueStruct(n, n2));
    }

    public DateTime(ValueStruct valueStruct) {
        Assert.errorParam(valueStruct == null, new ResourceTextPointer((Object)com.jronimo.text.ResourceTextIdentifiers.MUST_NOT_BE_NULL, "struct"));
        valueStruct = this.ratifyStruct(valueStruct);
        if (valueStruct.stringValue != null) {
            this.initFromStringValue(valueStruct);
        } else if (valueStruct.temporalValue != null) {
            this.initFromTemporalValue(valueStruct);
        } else {
            throw new IllegalArgumentException(ResourceText.getText((Object)com.jronimo.text.ResourceTextIdentifiers.INVALID_STRUCT, (Object[])new String[]{"struct"}));
        }
        this.ratifyParts();
    }

    private ValueStruct ratifyStruct(ValueStruct valueStruct) {
        ValueStruct valueStruct2 = null;
        Object var3_3 = null;
        String string = null;
        long l = 0L;
        valueStruct2 = valueStruct.clone();
        if (valueStruct2.stringValue == null && valueStruct2.temporalValue != null) {
            l = Math.abs(valueStruct2.temporalValue);
            if (String.valueOf(l).length() < 14) {
                string = ResourceText.getText((Object)ResourceTextIdentifiers.NOT_LONG_ENOUGH);
            } else if (l < 10101000000000L) {
                string = ResourceText.getText((Object)ResourceTextIdentifiers.VALUE_CANNOT_BE_LESS_THAN_ABS_VALUE, (Object[])new String[]{"10101000000000"});
            } else if (l > 9223371231235959999L) {
                string = ResourceText.getText((Object)ResourceTextIdentifiers.VALUE_CANNOT_BE_GREATER_THAN_ABS_VALUE, (Object[])new String[]{"9223371231235959999"});
            }
        }
        if (var3_3 != null) {
            throw new IllegalArgumentException(ResourceText.getText((Object)ResourceTextIdentifiers.INVALID_STRING_VALUE, (Object[])new String[]{valueStruct2.stringValue, "DateTime", var3_3}));
        }
        if (string != null) {
            throw new IllegalArgumentException(ResourceText.getText((Object)ResourceTextIdentifiers.INVALID_TEMPORAL_VALUE, (Object[])new String[]{String.valueOf(valueStruct2.temporalValue), "DateTime", string}));
        }
        return valueStruct2;
    }

    private void ratifyParts() {
    }

    private void initFromStringValue(ValueStruct valueStruct) {
        NullFreeMutableList<String> nullFreeMutableList = null;
        String string = null;
        String string2 = null;
        ValueStruct valueStruct2 = null;
        try {
            valueStruct.isDateTime = true;
            this.date = new Date(valueStruct);
            nullFreeMutableList = new StringWrapper(valueStruct.stringValue).split(" ");
            if (nullFreeMutableList.size() > 1 && (string = (String)nullFreeMutableList.get(1)).indexOf(":") >= 0) {
                string2 = (String)new StringWrapper(string).split(" ").getFirst();
            }
            if (string2 == null) {
                string2 = "00:00:00.000";
            }
            valueStruct2 = new ValueStruct(string2, this.date.hasExplicitTimezone() ? Integer.valueOf(this.date.getTimezone().getId()) : null);
            this.time = new TimeOfDay(valueStruct2);
            string = String.valueOf(this.date.getTemporalValue()) + new StringWrapper(this.time.getTemporalValue()).pad(9, "0", false);
            this.temporalValue = Long.parseLong(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw illegalArgumentException;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            string = ResourceText.getText((Object)ResourceTextIdentifiers.UNSPECIFIED_ISSUE);
            throw new IllegalArgumentException(ResourceText.getText((Object)ResourceTextIdentifiers.INVALID_STRING_VALUE, (Object[])new String[]{valueStruct.stringValue, "DateTime", string}));
        }
    }

    private void initFromTemporalValue(ValueStruct valueStruct) {
        String string = null;
        try {
            this.temporalValue = valueStruct.temporalValue;
            string = String.valueOf(valueStruct.temporalValue);
            this.time = new TimeOfDay(new ValueStruct(Long.valueOf(string.substring(string.length() - 9)), valueStruct.timezoneId));
            string = string.substring(0, string.length() - 9);
            this.date = new Date(Long.valueOf(string), valueStruct.timezoneId);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw illegalArgumentException;
        }
        catch (Exception exception) {
            string = ResourceText.getText((Object)ResourceTextIdentifiers.UNSPECIFIED_ISSUE);
            throw new IllegalArgumentException(ResourceText.getText((Object)ResourceTextIdentifiers.INVALID_TEMPORAL_VALUE, (Object[])new String[]{String.valueOf(valueStruct.temporalValue), "DateTime", string}));
        }
    }

    public String getString(StringFormat stringFormat) {
        StringBuilder stringBuilder = null;
        boolean bl = false;
        boolean bl2 = false;
        stringFormat = stringFormat == null ? new StringFormat() : stringFormat.clone();
        stringFormat.setDateFormatIfNull(new StringFormat.DateFormat(true));
        stringFormat.setTimeFormatIfNull(new StringFormat.TimeFormat(true));
        stringFormat.setTimezoneFormatIfNull(new StringFormat.TimezoneFormat());
        if (stringFormat.getDateFormat().includeDate()) {
            stringFormat.getDateFormat().setSeparatorIfNull(Constants.DateSeparator.HYPHEN);
            stringFormat.getDateFormat().setUseAdBcIfNull(false);
            stringFormat.getDateFormat().setMonthFormatIfNull(Constants.MonthFormat.NUMBER);
        }
        if (stringFormat.getTimeFormat().includeTime()) {
            stringFormat.getTimeFormat().setTimeFormatIfNull(Constants.TimeFormat.HHMMSSMMM);
            stringFormat.getTimeFormat().setSeparatorIfNull(Constants.TimeSeparator.COLON);
            stringFormat.getTimeFormat().setIncludeLeadingSpaceIfNull(true);
        }
        stringFormat.getTimezoneFormat().setIncludeTimezoneIdIfNull(this.hasExplicitTimezone());
        stringFormat.getTimezoneFormat().setIncludeTimezoneNameIfNull(false);
        bl = stringFormat.getTimezoneFormat().includeTimezoneId();
        bl2 = stringFormat.getTimezoneFormat().includeTimezoneName();
        stringFormat = new StringFormat(stringFormat.getDateFormat().typeClone(), stringFormat.getTimeFormat().typeClone(), new StringFormat.TimezoneFormat(false, false));
        stringBuilder = new StringBuilder();
        if (stringFormat.getDateFormat().includeDate()) {
            stringBuilder.append(this.date.getString(stringFormat));
        }
        if (stringFormat.getTimeFormat().includeTime()) {
            if (stringBuilder.length() > 0 && stringFormat.getTimeFormat().includeLeadingSpace().booleanValue()) {
                stringBuilder.append(" ");
            }
            stringBuilder.append(this.time.getString(stringFormat));
        }
        if (bl || bl2) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(" ");
            }
            if (bl2) {
                stringBuilder.append(this.getTimezone().getText());
            } else if (bl) {
                stringBuilder.append(this.getTimezone().getId());
            }
        }
        return stringBuilder.toString();
    }

    public long getTemporalValue() {
        return this.temporalValue;
    }

    public Date getDate() {
        return this.date;
    }

    public TimeOfDay getTime() {
        return this.time;
    }

    public boolean isNegative() {
        return this.date.isNegative();
    }

    public int getYear() {
        return this.date.getYear();
    }

    public byte getMonth() {
        return this.date.getMonth();
    }

    public byte getDay() {
        return this.date.getDay();
    }

    public byte getHour() {
        return this.time.getHour();
    }

    public byte getMinute() {
        return this.time.getMinute();
    }

    public byte getSecond() {
        return this.time.getSecond();
    }

    public short getMillisecond() {
        return this.time.getMillisecond();
    }

    public Timezone getTimezone() {
        return this.date.getTimezone();
    }

    public boolean hasExplicitTimezone() {
        return this.date.hasExplicitTimezone();
    }

    public synchronized DateTime getUtcZeroInstance() {
        DateTime dateTime = null;
        DateTime dateTime2 = null;
        dateTime = this.utcZeroInstance;
        if (dateTime == null) {
            dateTime2 = new DateTime(this.getTemporalValue(), this.hasExplicitTimezone() ? Integer.valueOf(0) : null);
            dateTime = this.utcZeroInstance = DateTime.addMilliseconds(dateTime2, -1 * this.date.getTimezone().getOffsetAdjustment(this.getCalendar()));
        }
        return this.utcZeroInstance;
    }

    public DateTime getTimezoneInstance(int n) {
        DateTime dateTime = null;
        DateTime dateTime2 = null;
        dateTime2 = DateTime.addMilliseconds(this.getUtcZeroInstance(), Timezone.getTimezone(n).getOffsetAdjustment(this.getCalendar()));
        dateTime = new DateTime(dateTime2.getTemporalValue(), (Integer)n);
        return dateTime;
    }

    public boolean equalTo(DateTime dateTime, boolean bl) {
        return bl ? DateTime.compareWithTimezones(this, dateTime) == 0 : DateTime.compareWithoutTimezones(this, dateTime) == 0;
    }

    public boolean lessThan(DateTime dateTime, boolean bl) {
        return bl ? DateTime.compareWithTimezones(this, dateTime) < 0 : DateTime.compareWithoutTimezones(this, dateTime) < 0;
    }

    public boolean lessThanOrEqualTo(DateTime dateTime, boolean bl) {
        return bl ? DateTime.compareWithTimezones(this, dateTime) <= 0 : DateTime.compareWithoutTimezones(this, dateTime) <= 0;
    }

    public boolean greaterThan(DateTime dateTime, boolean bl) {
        return bl ? DateTime.compareWithTimezones(this, dateTime) > 0 : DateTime.compareWithoutTimezones(this, dateTime) > 0;
    }

    public boolean greaterThanOrEqualTo(DateTime dateTime, boolean bl) {
        return bl ? DateTime.compareWithTimezones(this, dateTime) >= 0 : DateTime.compareWithoutTimezones(this, dateTime) >= 0;
    }

    public Time difference(DateTime dateTime, boolean bl) {
        Time time = null;
        Calendar calendar = null;
        Calendar calendar2 = null;
        ValueStruct valueStruct = null;
        Assert.errorParam(dateTime == null, new ResourceTextPointer((Object)com.jronimo.text.ResourceTextIdentifiers.MUST_NOT_BE_NULL, "instance"));
        if (bl) {
            calendar = this.getCalendar();
            calendar2 = dateTime.getCalendar();
        } else {
            calendar = this.getCalendar();
            if (this.getTimezone().getId() != 0) {
                calendar.setTimeZone(Timezone.getTimezone(0).getJavaTimeZone());
            }
            calendar2 = dateTime.getCalendar();
            if (dateTime.getTimezone().getId() != 0) {
                calendar2.setTimeZone(Timezone.getTimezone(0).getJavaTimeZone());
            }
        }
        valueStruct = new ValueStruct();
        valueStruct.millisecondValue = calendar.getTime().getTime() - calendar2.getTime().getTime();
        time = new Time(valueStruct);
        return time;
    }

    public synchronized Calendar getCalendar() {
        if (this.calendar == null) {
            this.calendar = this.date.getCalendar();
            this.calendar.set(11, this.time.getHour());
            this.calendar.set(12, this.time.getMinute());
            this.calendar.set(13, this.time.getSecond());
            this.calendar.set(14, this.time.getMillisecond());
        }
        return (Calendar)this.calendar.clone();
    }

    public int getDayOfWeekNumber() {
        return this.date.getDayOfWeekNumber();
    }

    public String getDayOfWeekName() {
        return this.date.getDayOfWeekName();
    }

    public String getDayOfWeekShortName() {
        return this.date.getDayOfWeekShortName();
    }

    public boolean isWeekDay() {
        return this.date.isWeekDay();
    }

    public boolean isPublicHoliday(PublicHolidayLookup publicHolidayLookup) {
        Assert.errorParam(publicHolidayLookup == null, new ResourceTextPointer((Object)com.jronimo.text.ResourceTextIdentifiers.MUST_NOT_BE_NULL, "lookup"));
        return publicHolidayLookup.isPublicHoliday(this.date);
    }

    public byte getWeekNumber() {
        return this.date.getWeekNumber();
    }

    public byte getDaysInMonth() {
        return this.date.getDaysInMonth();
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object object) {
        boolean bl = false;
        DateTime dateTime = null;
        if (object instanceof DateTime) {
            dateTime = (DateTime)object;
            if (this.temporalValue == dateTime.temporalValue && this.getTimezone().equals(dateTime.getTimezone())) {
                bl = true;
            }
        }
        return bl;
    }

    public String toString() {
        return this.getString(null);
    }

    public int compareTo(Object object) {
        int n = 0;
        DateTime dateTime = null;
        if (object instanceof DateTime) {
            dateTime = (DateTime)object;
            n = this.hasExplicitTimezone() && dateTime.hasExplicitTimezone() ? DateTime.compareWithTimezones(this, dateTime) : DateTime.compareWithoutTimezones(this, dateTime);
        } else {
            n = 1;
        }
        return n;
    }

    private static int compareWithoutTimezones(DateTime dateTime, DateTime dateTime2) {
        int n = 0;
        Calendar calendar = null;
        Calendar calendar2 = null;
        if (dateTime == null && dateTime2 != null) {
            n = -1;
        } else if (dateTime != null && dateTime2 == null) {
            n = 1;
        } else if (dateTime == null && dateTime2 == null) {
            n = 0;
        } else {
            calendar = dateTime.getCalendar();
            calendar2 = dateTime2.getCalendar();
            if (dateTime.getTimezone().getId() != 0) {
                calendar.setTimeZone(Timezone.getTimezone(0).getJavaTimeZone());
            }
            if (dateTime2.getTimezone().getId() != 0) {
                calendar2.setTimeZone(Timezone.getTimezone(0).getJavaTimeZone());
            }
            if (calendar.before(calendar2)) {
                n = -1;
            } else if (calendar.after(calendar2)) {
                n = 1;
            }
        }
        return n;
    }

    private static int compareWithTimezones(DateTime dateTime, DateTime dateTime2) {
        int n = 0;
        if (dateTime == null && dateTime2 != null) {
            n = -1;
        } else if (dateTime != null && dateTime2 == null) {
            n = 1;
        } else if (dateTime == null && dateTime2 == null) {
            n = 0;
        } else if (dateTime.getCalendar().before(dateTime2.getCalendar())) {
            n = -1;
        } else if (dateTime.getCalendar().after(dateTime2.getCalendar())) {
            n = 1;
        }
        return n;
    }

    public static DateTime now(boolean bl) {
        return DateTime.now(bl, null);
    }

    public static DateTime now(boolean bl, Integer n) {
        DateTime dateTime = null;
        int n2 = 0;
        if (bl) {
            n2 = Timezone.getTimezoneByJavaId(Calendar.getInstance().getTimeZone().getID()).getId();
        }
        dateTime = DateTime.now(n2, n);
        return dateTime;
    }

    public static DateTime now(int n) {
        return DateTime.now(n, null);
    }

    public static DateTime now(int n, Integer n2) {
        DateTime dateTime = null;
        Timezone timezone = null;
        Calendar calendar = null;
        timezone = Timezone.getTimezone(n);
        Assert.errorParam(timezone == null, new ResourceTextPointer((Object)com.jronimo.text.ResourceTextIdentifiers.UNRECOGNIZED_VALUE, "nowTimezoneId", String.valueOf(n)));
        if (n2 == null) {
            n2 = n;
        }
        calendar = Calendar.getInstance(timezone.getJavaTimeZone());
        dateTime = new DateTime(TemporalUtils.calendarToString(calendar) + " " + n2);
        return dateTime;
    }

    public static DateTime createInstance(long l, boolean bl) {
        return DateTime.createInstance(l, bl, null);
    }

    public static DateTime createInstance(long l, boolean bl, Integer n) {
        DateTime dateTime = null;
        int n2 = 0;
        if (bl) {
            n2 = Timezone.getTimezoneByJavaId(Calendar.getInstance().getTimeZone().getID()).getId();
        }
        dateTime = DateTime.createInstance(l, n2, n);
        return dateTime;
    }

    public static DateTime createInstance(long l, int n) {
        return DateTime.createInstance(l, n, null);
    }

    public static DateTime createInstance(long l, int n, Integer n2) {
        DateTime dateTime = null;
        Timezone timezone = null;
        Calendar calendar = null;
        timezone = Timezone.getTimezone(n);
        Assert.errorParam(timezone == null, new ResourceTextPointer((Object)com.jronimo.text.ResourceTextIdentifiers.UNRECOGNIZED_VALUE, "nowTimezoneId", String.valueOf(n)));
        if (n2 == null) {
            n2 = n;
        }
        calendar = Calendar.getInstance(timezone.getJavaTimeZone());
        calendar.setTimeInMillis(l);
        dateTime = new DateTime(TemporalUtils.calendarToString(calendar) + " " + n2);
        return dateTime;
    }

    public static DateTime addYears(DateTime dateTime, int n) {
        return DateTime.add(dateTime, 1, n);
    }

    public static DateTime addMonths(DateTime dateTime, int n) {
        return DateTime.add(dateTime, 2, n);
    }

    public static DateTime addDays(DateTime dateTime, int n) {
        return DateTime.add(dateTime, 6, n);
    }

    public static DateTime addHours(DateTime dateTime, long l) {
        return DateTime.add(dateTime, 11, l);
    }

    public static DateTime addMinutes(DateTime dateTime, long l) {
        return DateTime.add(dateTime, 12, l);
    }

    public static DateTime addSeconds(DateTime dateTime, long l) {
        return DateTime.add(dateTime, 13, l);
    }

    public static DateTime addMilliseconds(DateTime dateTime, long l) {
        return DateTime.add(dateTime, 14, l);
    }

    private static DateTime add(DateTime dateTime, int n, long l) {
        DateTime dateTime2 = null;
        Calendar calendar = null;
        StringFormat stringFormat = null;
        calendar = dateTime.getCalendar();
        TemporalUtils.add(calendar, n, l);
        stringFormat = new StringFormat(new StringFormat.TimezoneFormat(dateTime.hasExplicitTimezone()));
        dateTime2 = new DateTime(TemporalUtils.calendarToString(calendar, stringFormat));
        return dateTime2;
    }

    public static class WithTimezoneAdjustmentComparator
    implements Comparator {
        public int compare(Object object, Object object2) {
            int n = 0;
            n = object instanceof DateTime && !(object2 instanceof DateTime) ? 1 : (!(object instanceof DateTime) && object2 instanceof DateTime ? -1 : (!(object instanceof DateTime) && !(object2 instanceof DateTime) ? 0 : DateTime.compareWithTimezones((DateTime)object, (DateTime)object2)));
            return n;
        }
    }

    public static class WithoutTimezoneAdjustmentComparator
    implements Comparator {
        public int compare(Object object, Object object2) {
            int n = 0;
            n = object instanceof DateTime && !(object2 instanceof DateTime) ? 1 : (!(object instanceof DateTime) && object2 instanceof DateTime ? -1 : (!(object instanceof DateTime) && !(object2 instanceof DateTime) ? 0 : DateTime.compareWithoutTimezones((DateTime)object, (DateTime)object2)));
            return n;
        }
    }
}

