/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.temporal;

import com.jronimo.temporal.ResourceTextIdentifiers;
import com.jronimo.temporal.TemporalUtils;
import com.jronimo.text.ResourceText;

public interface Constants {

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum UnitOfTime {
        SECOND(1000),
        MINUTE(60 * SECOND.getMilliseconds()),
        HOUR(60 * MINUTE.getMilliseconds()),
        DAY(24 * HOUR.getMilliseconds());

        private int milliseconds;

        private UnitOfTime(int n2) {
            this.milliseconds = n2;
        }

        public int getMilliseconds() {
            return this.milliseconds;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TimeFormat {
        HHMMSSMMM("hhmmssmmm"),
        HHMMSS("hhmmss"),
        HHMM("hhmm");

        private String format;

        private TimeFormat(String string2) {
            this.format = string2;
        }

        public String toString() {
            return this.format;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DayOfWeek {
        MONDAY("Monday", "Mon", 1),
        TUESDAY("Tuesday", "Tue", 2),
        WEDNESDAY("Wednesday", "Wed", 3),
        THURSDAY("Thursday", "Thu", 4),
        FRIDAY("Friday", "Fri", 5),
        SATURDAY("Saturday", "Sat", 6),
        SUNDAY("Sunday", "Sun", 7);

        private String name;
        private String abbreviation;
        private int number;

        private DayOfWeek(String string2, String string3, int n2) {
            this.name = string2;
            this.abbreviation = string3;
            this.number = n2;
        }

        public String getName() {
            String string = null;
            string = ResourceText.getText((Object)ResourceTextIdentifiers.valueOf(this.name.toUpperCase()));
            return string;
        }

        public String getAbbreviation() {
            String string = null;
            string = ResourceText.getText((Object)ResourceTextIdentifiers.valueOf(this.abbreviation.toUpperCase()));
            return string;
        }

        public int getNumber() {
            return this.number;
        }

        public boolean isWeekDay() {
            return this.number <= 5;
        }

        public static DayOfWeek getDayByName(String string) {
            DayOfWeek dayOfWeek = null;
            for (DayOfWeek dayOfWeek2 : DayOfWeek.values()) {
                if (!dayOfWeek2.name.equals(string)) continue;
                dayOfWeek = dayOfWeek2;
                break;
            }
            return dayOfWeek;
        }

        public static DayOfWeek getDayByAbbreviation(String string) {
            DayOfWeek dayOfWeek = null;
            for (DayOfWeek dayOfWeek2 : DayOfWeek.values()) {
                if (!dayOfWeek2.abbreviation.equals(string)) continue;
                dayOfWeek = dayOfWeek2;
                break;
            }
            return dayOfWeek;
        }

        public static DayOfWeek getDayByNumber(int n) {
            DayOfWeek dayOfWeek = null;
            for (DayOfWeek dayOfWeek2 : DayOfWeek.values()) {
                if (dayOfWeek2.number != n) continue;
                dayOfWeek = dayOfWeek2;
                break;
            }
            return dayOfWeek;
        }

        public String toString() {
            return this.getName();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Month {
        JANUARY("January", "Jan", 1, 31),
        FEBRUARY("February", "Feb", 2, 28),
        MARCH("March", "Mar", 3, 31),
        APRIL("April", "Apr", 4, 30),
        MAY("May", "May", 5, 31),
        JUNE("June", "Jun", 6, 30),
        JULY("July", "Jul", 7, 31),
        AUGUST("August", "Aug", 8, 31),
        SEPTEMBER("September", "Sep", 9, 30),
        OCTOBER("October", "Oct", 10, 31),
        NOVEMBER("November", "Nov", 11, 30),
        DECEMBER("December", "Dec", 12, 31);

        private String name;
        private String abbreviation;
        private int number;
        private int numberOfDays;

        private Month(String string2, String string3, int n2, int n3) {
            this.name = string2;
            this.abbreviation = string3;
            this.number = n2;
            this.numberOfDays = n3;
        }

        public String getName() {
            String string = null;
            string = ResourceText.getText((Object)ResourceTextIdentifiers.valueOf(this.name.toUpperCase()));
            return string;
        }

        public String getAbbreviation() {
            String string = null;
            string = ResourceText.getText((Object)ResourceTextIdentifiers.valueOf(this.abbreviation.toUpperCase() + "_ABBREV"));
            return string;
        }

        public int getNumber() {
            return this.number;
        }

        public int getNumberOfDays(long l) {
            int n = 0;
            n = this.numberOfDays;
            if (this.number == 2 && TemporalUtils.isLeapYear(l)) {
                ++n;
            }
            return n;
        }

        public static Month getMonthByName(String string) {
            Month month = null;
            for (Month month2 : Month.values()) {
                if (!month2.name.equals(string)) continue;
                month = month2;
                break;
            }
            return month;
        }

        public static Month getMonthByAbbreviation(String string) {
            Month month = null;
            for (Month month2 : Month.values()) {
                if (!month2.abbreviation.equals(string)) continue;
                month = month2;
                break;
            }
            return month;
        }

        public static Month getMonthByNumber(int n) {
            Month month = null;
            for (Month month2 : Month.values()) {
                if (month2.number != n) continue;
                month = month2;
                break;
            }
            return month;
        }

        public String toString() {
            return this.getName();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MonthFormat {
        NUMBER,
        ABBREVIATION,
        NAME;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TimeSeparator {
        COLON(":"),
        SPACE(" "),
        NONE("");

        private String separator;

        private TimeSeparator(String string2) {
            this.separator = string2;
        }

        public String getSeparator() {
            return this.separator;
        }

        public String toString() {
            return this.separator;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DateSeparator {
        HYPHEN("-"),
        FORWARD_SLASH("/"),
        DOT("."),
        SPACE(" "),
        NONE("");

        private String separator;

        private DateSeparator(String string2) {
            this.separator = string2;
        }

        public String getSeparator() {
            return this.separator;
        }

        public String toString() {
            return this.separator;
        }
    }
}

