/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.systemconfiguration.loader.nodeloaders;

import com.jronimo.collections.collection.CollectionUtils;
import com.jronimo.collections.collection.types.nullfree.NullFreeCollection;
import com.jronimo.systemconfiguration.SystemConfiguration;
import com.jronimo.systemconfiguration.SystemRole;
import com.jronimo.util.Logger;
import com.jronimo.xml.XmlElement;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleSystemRolesNodeLoader {
    private static final Logger logger = Logger.getLogger(SimpleSystemRolesNodeLoader.class);
    private XmlElement elements;
    private SystemConfiguration system;

    public SimpleSystemRolesNodeLoader(XmlElement xmlElement, SystemConfiguration systemConfiguration) {
        this.elements = xmlElement;
        this.system = systemConfiguration;
    }

    public Collection<SystemRole> execute() throws Exception {
        Set set = null;
        NullFreeCollection<XmlElement> nullFreeCollection = null;
        nullFreeCollection = this.elements.getOptionalElements("system-role");
        set = CollectionUtils.getOrderedSet(new HashSet(nullFreeCollection.size()));
        for (XmlElement xmlElement : nullFreeCollection) {
            set.add(this.system.getSystemRole(xmlElement.getText()));
        }
        return set;
    }
}

