/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.systemconfiguration.loader.nodeloaders;

import com.jronimo.systemconfiguration.BusinessObjectPermission;
import com.jronimo.systemconfiguration.Constants;
import com.jronimo.systemconfiguration.EntityPermission;
import com.jronimo.systemconfiguration.EntityPermissionSecurityClause;
import com.jronimo.systemconfiguration.Permission;
import com.jronimo.systemconfiguration.SecurityConfiguration;
import com.jronimo.systemconfiguration.SystemConfiguration;
import com.jronimo.systemconfiguration.loader.nodeloaders.SimpleSystemRolesNodeLoader;
import com.jronimo.util.Logger;
import com.jronimo.xml.XmlElement;

public class SecurityConfigurationNodeLoader {
    private static final Logger logger = Logger.getLogger(SecurityConfigurationNodeLoader.class);
    private XmlElement element;
    private SystemConfiguration system;

    public SecurityConfigurationNodeLoader(XmlElement xmlElement, SystemConfiguration systemConfiguration) {
        this.element = xmlElement;
        this.system = systemConfiguration;
    }

    public SecurityConfiguration execute() throws Exception {
        SecurityConfiguration securityConfiguration = null;
        securityConfiguration = new SecurityConfiguration();
        this.loadPermissionsNode(this.element.getElement("permissions"), securityConfiguration);
        return securityConfiguration;
    }

    private void loadPermissionsNode(XmlElement xmlElement, SecurityConfiguration securityConfiguration) throws Exception {
        for (XmlElement xmlElement2 : xmlElement.getOptionalElements("permission")) {
            this.loadPermissionNode(xmlElement2, securityConfiguration);
        }
    }

    private void loadPermissionNode(XmlElement xmlElement, SecurityConfiguration securityConfiguration) throws Exception {
        Permission permission = null;
        permission = new Permission(xmlElement.getLong("id"), new SimpleSystemRolesNodeLoader(xmlElement.getElement("system-roles"), this.system).execute());
        if (xmlElement.hasElement("entity-permissions")) {
            this.loadEntityPermissionsNode(xmlElement.getElement("entity-permissions"), permission, securityConfiguration);
        }
        if (xmlElement.hasElement("business-object-permissions")) {
            this.loadBusinessObjectPermissionsNode(xmlElement.getElement("business-object-permissions"), permission);
        }
        securityConfiguration.addPermission(permission, this.system);
    }

    private void loadEntityPermissionsNode(XmlElement xmlElement, Permission permission, SecurityConfiguration securityConfiguration) throws Exception {
        for (XmlElement xmlElement2 : xmlElement.getOptionalElements("entity-permission")) {
            this.loadEntityPermissionNode(xmlElement2, permission, securityConfiguration);
        }
    }

    private void loadEntityPermissionNode(XmlElement xmlElement, Permission permission, SecurityConfiguration securityConfiguration) throws Exception {
        EntityPermission entityPermission = null;
        entityPermission = new EntityPermission(xmlElement.getLong("id"), xmlElement.getText("entity-name"));
        for (XmlElement xmlElement2 : xmlElement.getOptionalElements("security-clause")) {
            this.loadEntityPermissionSecurityClauseNode(xmlElement2, entityPermission);
        }
        permission.addEntityPermission(entityPermission);
    }

    private void loadEntityPermissionSecurityClauseNode(XmlElement xmlElement, EntityPermission entityPermission) throws Exception {
        EntityPermissionSecurityClause entityPermissionSecurityClause = null;
        entityPermissionSecurityClause = new EntityPermissionSecurityClause(xmlElement.getLong("id"), xmlElement.getText("clause"));
        for (XmlElement xmlElement2 : xmlElement.getOptionalElements("operations/operation-name")) {
            entityPermissionSecurityClause.addSupportedOperation(Constants.EntityOperation.get(xmlElement2.getText()));
        }
        for (XmlElement xmlElement2 : xmlElement.getOptionalElements("read-fields/field-name")) {
            entityPermissionSecurityClause.addReadField(xmlElement2.getText());
        }
        for (XmlElement xmlElement2 : xmlElement.getOptionalElements("update-fields/field-name")) {
            entityPermissionSecurityClause.addUpdateField(xmlElement2.getText());
        }
        for (XmlElement xmlElement2 : xmlElement.getOptionalElements("create-fields/field-name")) {
            entityPermissionSecurityClause.addCreateField(xmlElement2.getText());
        }
        entityPermission.addSecurityClause(entityPermissionSecurityClause, this.system.getRepository().getEntity(entityPermission.getEntityName()));
    }

    private void loadBusinessObjectPermissionsNode(XmlElement xmlElement, Permission permission) throws Exception {
        for (XmlElement xmlElement2 : xmlElement.getOptionalElements("business-object-permission")) {
            this.loadBusinessObjectPermissionNode(xmlElement2, permission);
        }
    }

    private void loadBusinessObjectPermissionNode(XmlElement xmlElement, Permission permission) throws Exception {
        BusinessObjectPermission businessObjectPermission = null;
        businessObjectPermission = new BusinessObjectPermission(xmlElement.getElement("business-object-name").getText());
        for (XmlElement xmlElement2 : xmlElement.getOptionalElements("operations/operation-name")) {
            businessObjectPermission.addSupportedOperation(xmlElement2.getText());
        }
        permission.addBusinessObjectPermission(businessObjectPermission);
    }
}

