/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.systemconfiguration.loader.nodeloaders;

import com.jronimo.collections.collection.CollectionUtils;
import com.jronimo.collections.collection.types.nullfree.NullFreeCollection;
import com.jronimo.systemconfiguration.Relationship;
import com.jronimo.util.Logger;
import com.jronimo.xml.XmlElement;

public class RelationshipNodeLoader {
    private static final Logger logger = Logger.getLogger(RelationshipNodeLoader.class);
    private XmlElement element;

    public RelationshipNodeLoader(XmlElement xmlElement) {
        this.element = xmlElement;
    }

    public Relationship execute() throws Exception {
        Relationship relationship = null;
        NullFreeCollection<XmlElement> nullFreeCollection = null;
        nullFreeCollection = this.element.getElements("entity-types/name", 2);
        relationship = new Relationship(this.element.getText("name"), this.element.getText("type"), ((XmlElement)CollectionUtils.getCollectionElement(nullFreeCollection, 0)).getText(), ((XmlElement)CollectionUtils.getCollectionElement(nullFreeCollection, 1)).getText(), this.element.getText("comments"));
        if (this.element.hasElement("cascade-delete")) {
            relationship.setCascadeDelete(this.element.getBoolean("cascade-delete"));
        }
        this.loadLinkNode(this.element.getElement("link"), relationship);
        this.loadVirtualFieldsNode(this.element.getElement("virtual-fields"), relationship);
        return relationship;
    }

    private void loadLinkNode(XmlElement xmlElement, Relationship relationship) throws Exception {
        Relationship.Link link = null;
        link = new Relationship.Link(xmlElement.getText("type"));
        if (xmlElement.hasElement("link-entity")) {
            link.setLinkEntity(xmlElement.getText("link-entity"));
        }
        if (xmlElement.hasElement("holding-entity")) {
            link.setHoldingEntity(xmlElement.getText("holding-entity"));
        }
        for (XmlElement xmlElement2 : xmlElement.getOptionalElements("mappings/mapping")) {
            this.loadLinkMappingNode(xmlElement2, link);
        }
        relationship.setLink(link);
    }

    private void loadLinkMappingNode(XmlElement xmlElement, Relationship.Link link) throws Exception {
        Relationship.Mapping mapping = null;
        mapping = new Relationship.Mapping();
        for (XmlElement xmlElement2 : xmlElement.getOptionalElements("member")) {
            this.loadLinkMappingMemberNode(xmlElement2, mapping);
        }
        link.addMapping(mapping);
    }

    private void loadLinkMappingMemberNode(XmlElement xmlElement, Relationship.Mapping mapping) throws Exception {
        Relationship.MappingMemberStruct mappingMemberStruct = null;
        mappingMemberStruct = new Relationship.MappingMemberStruct();
        mappingMemberStruct.entityName = xmlElement.getText("entity-name");
        mappingMemberStruct.fieldName = xmlElement.getText("field-name");
        mapping.addMember(mappingMemberStruct);
    }

    private void loadVirtualFieldsNode(XmlElement xmlElement, Relationship relationship) throws Exception {
        for (XmlElement xmlElement2 : xmlElement.getOptionalElements("virtual-field")) {
            this.loadVirtualFieldNode(xmlElement2, relationship);
        }
    }

    private void loadVirtualFieldNode(XmlElement xmlElement, Relationship relationship) throws Exception {
        Relationship.VirtualField virtualField = null;
        virtualField = new Relationship.VirtualField(xmlElement.getText("entity-name"), xmlElement.getText("field-name"));
        relationship.addVirtualField(virtualField);
    }
}

