/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.systemconfiguration.loader.nodeloaders;

import com.jronimo.collections.collection.CollectionUtils;
import com.jronimo.collections.collection.types.nullfree.NullFreeCollection;
import com.jronimo.systemconfiguration.Constants;
import com.jronimo.systemconfiguration.DataSource;
import com.jronimo.util.Logger;
import com.jronimo.xml.XmlElement;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataSourcesNodeLoader {
    private static final Logger logger = Logger.getLogger(DataSourcesNodeLoader.class);
    private XmlElement element;

    public DataSourcesNodeLoader(XmlElement xmlElement) {
        this.element = xmlElement;
    }

    public Collection<DataSource> execute() throws Exception {
        Set set = null;
        NullFreeCollection<XmlElement> nullFreeCollection = null;
        nullFreeCollection = this.element.getOptionalElements("data-source");
        set = CollectionUtils.getOrderedSet(new HashSet(nullFreeCollection.size()));
        for (XmlElement xmlElement : nullFreeCollection) {
            set.add(this.loadDataSource(xmlElement));
        }
        return set;
    }

    private DataSource loadDataSource(XmlElement xmlElement) throws Exception {
        DataSource dataSource = null;
        String string = null;
        boolean bl = false;
        Constants.DataSourceType dataSourceType = null;
        XmlElement xmlElement2 = null;
        String string2 = null;
        String string3 = null;
        DataSource.SequenceDetails sequenceDetails = null;
        string = xmlElement.getText("name");
        bl = xmlElement.getBoolean("is-default");
        dataSourceType = Constants.DataSourceType.get(xmlElement.getText("type"));
        if (dataSourceType == Constants.DataSourceType.RDBMS) {
            xmlElement2 = xmlElement.getElement("rdbms");
            string2 = xmlElement2.getText("default-schema");
            string3 = xmlElement2.getText("audit-schema");
            sequenceDetails = this.loadSequenceDetails(xmlElement2.getElement("sequences"));
            dataSource = new DataSource(string, bl, dataSourceType, string2, string3, sequenceDetails);
            for (XmlElement xmlElement3 : xmlElement2.getOptionalElements("other-schemas/schema")) {
                dataSource.addOtherSchema(xmlElement3.getText());
            }
        } else {
            dataSource = new DataSource(string, bl, dataSourceType);
        }
        return dataSource;
    }

    private DataSource.SequenceDetails loadSequenceDetails(XmlElement xmlElement) throws Exception {
        DataSource.SequenceDetails sequenceDetails = null;
        if (xmlElement != null) {
            sequenceDetails = new DataSource.SequenceDetails();
            sequenceDetails.sequenceType = Constants.SequenceType.get(xmlElement.getText("sequence-type"));
            sequenceDetails.sequenceTableName = xmlElement.getText("sequence-table-name");
            sequenceDetails.groupingSequenceName = xmlElement.getText("grouping-sequence-name");
        }
        return sequenceDetails;
    }
}

