/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.systemconfiguration.loader.legacy;

import com.jronimo.collections.collection.CollectionUtils;
import com.jronimo.engines.databasemetadata.Column;
import com.jronimo.engines.databasemetadata.PersistenceNameConverter;
import com.jronimo.engines.databasemetadata.SchemaMetaData;
import com.jronimo.engines.databasemetadata.Table;
import com.jronimo.nameformat.SimpleNameFormat;
import com.jronimo.systemconfiguration.BusinessObject;
import com.jronimo.systemconfiguration.BusinessObjectOperation;
import com.jronimo.systemconfiguration.BusinessObjectPermission;
import com.jronimo.systemconfiguration.Constants;
import com.jronimo.systemconfiguration.ConstraintSet;
import com.jronimo.systemconfiguration.DataSourceFieldType;
import com.jronimo.systemconfiguration.DataType;
import com.jronimo.systemconfiguration.DefaultValue;
import com.jronimo.systemconfiguration.Entity;
import com.jronimo.systemconfiguration.EntityOperationsConfiguration;
import com.jronimo.systemconfiguration.EntityPermission;
import com.jronimo.systemconfiguration.EntityPermissionSecurityClause;
import com.jronimo.systemconfiguration.Field;
import com.jronimo.systemconfiguration.Key;
import com.jronimo.systemconfiguration.Permission;
import com.jronimo.systemconfiguration.PrimaryKey;
import com.jronimo.systemconfiguration.Repository;
import com.jronimo.systemconfiguration.SecurityConfiguration;
import com.jronimo.systemconfiguration.SystemConfiguration;
import com.jronimo.systemconfiguration.SystemField;
import com.jronimo.systemconfiguration.SystemFieldType;
import com.jronimo.systemconfiguration.SystemRole;
import com.jronimo.systemconfiguration.loader.legacy.LoaderAssist;
import com.jronimo.systemconfiguration.loader.legacy.LoaderAssistLoader;
import com.jronimo.util.Logger;
import java.io.File;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoadFromLegacyRepository {
    private static final Logger logger = Logger.getLogger(LoadFromLegacyRepository.class);
    private static final List<String> SYSTEM_FIELDS = new ArrayList<String>(8);
    private static long idCounter;
    private Connection connection;
    private File loaderAssistFile;
    private LoaderAssist loaderAssist;
    private SchemaMetaData schemaMetaData;

    public LoadFromLegacyRepository(Connection connection, File file) {
        this.connection = connection;
        this.loaderAssistFile = file;
    }

    public SystemConfiguration execute() throws Exception {
        SystemConfiguration systemConfiguration = null;
        this.loaderAssist = new LoaderAssistLoader(this.loaderAssistFile).execute();
        this.schemaMetaData = new SchemaMetaData(this.connection, this.loaderAssist.getIgnoreTables(), SYSTEM_FIELDS, new PersistenceNameConverterImpl(this.loaderAssist.getDataSourceEngine())).load();
        systemConfiguration = new SystemConfiguration(this.loaderAssist.getSystemIdentifier(), this.loaderAssist.getLanguagesStruct().defaultLanguageCode, this.loaderAssist.getLanguagesStruct().defaultLanguageVariationCode);
        systemConfiguration.setLanguages(this.loaderAssist.getLanguagesStruct().languages);
        systemConfiguration.setSystemRoles(this.loaderAssist.getSystemRoles());
        this.addRepository(systemConfiguration);
        this.loaderAssist = null;
        this.schemaMetaData = null;
        return systemConfiguration;
    }

    private void addRepository(SystemConfiguration systemConfiguration) throws Exception {
        Repository repository = null;
        Object var3_3 = null;
        repository = new Repository();
        systemConfiguration.setRepository(repository);
        repository.setDataSources(this.loaderAssist.getDataSources());
        for (Table table : this.schemaMetaData.getTables()) {
            this.addEntity(repository, table);
        }
        this.addBusinessObjects(repository);
        this.addSecurityConfiguration(systemConfiguration, repository);
    }

    private void addEntity(Repository repository, Table table) throws Exception {
        String string = null;
        Entity entity = null;
        string = this.loaderAssist.getEntityNameMapping(table.getName());
        if (string == null) {
            string = new SimpleNameFormat(table.getName()).getCamelCase();
            string = string.substring(0, string.length() - 1);
        }
        entity = new Entity(0L, string, table.getName(), table.getComments());
        entity.addConstraintSet(new ConstraintSet("Base", null));
        repository.addEntity(entity);
        for (Column column : table.getColumns()) {
            this.addEntityField(entity, table, column);
        }
        this.addEntityPrimaryKey(entity, table);
        this.addEntityKeys(entity);
        this.addSystemFields(entity);
        this.addEntityOperationsConfiguration(entity);
    }

    private void addEntityField(Entity entity, Table table, Column column) throws Exception {
        String string = null;
        Field field = null;
        Object var6_6 = null;
        ConstraintSet constraintSet = null;
        string = this.loaderAssist.getFieldNameMapping(entity.getName(), column.getName());
        if (string == null) {
            string = new SimpleNameFormat(column.getName()).getCamelCase();
        }
        field = new Field(0L, string, column.getName(), column.getComments());
        new DefaultValue(LoadFromLegacyRepository.getDefaultValue(column.getDefaultValue()), field);
        entity.addField(field);
        field.setTypeDetails(this.getTypeDetails(entity, field, table, column));
        constraintSet = entity.getConstraintSet("Base");
        constraintSet.add(string);
        if (!column.allowsNull()) {
            constraintSet.add(string, new ConstraintSet.Constraint("NOT_NULL", null));
        }
        if (field.supportsCapacity(this.loaderAssist.getDataSourceEngine())) {
            constraintSet.add(string, new ConstraintSet.Constraint("MIN_LENGTH", "1", null, field));
            if (field.hasCapacity(this.loaderAssist.getDataSourceEngine())) {
                constraintSet.add(string, new ConstraintSet.Constraint("MAX_LENGTH", field.getCapacity(this.loaderAssist.getDataSourceEngine()).toString(), null, field));
            }
        }
    }

    private void addEntityPrimaryKey(Entity entity, Table table) throws Exception {
        PrimaryKey primaryKey = null;
        primaryKey = new PrimaryKey(Constants.PrimaryKeyType.SEQUENCE, table.getName());
        primaryKey.addFieldName("Id");
        entity.setPrimaryKey(primaryKey);
    }

    private void addEntityKeys(Entity entity) throws Exception {
        for (LoaderAssist.KeyDetails keyDetails : this.loaderAssist.getKeys(entity.getName())) {
            entity.addKey(new Key(keyDetails.getKeyName(), keyDetails.getFieldNames()));
        }
    }

    private Field.TypeDetails getTypeDetails(Entity entity, Field field, Table table, Column column) throws Exception {
        Field.TypeDetails typeDetails = null;
        DataType dataType = null;
        LoaderAssist.FieldTypeMapping fieldTypeMapping = null;
        String string = null;
        String string2 = null;
        Constants.DataSourceEngine dataSourceEngine = null;
        DataSourceFieldType dataSourceFieldType = null;
        dataType = table.isPrimaryKeyColumn(column.getName()) ? DataType.getDataType("DataServiceId") : (this.loaderAssist.isForeignKeyColumn(table.getName(), column.getName()) ? DataType.getDataType("ForeignKeyMember") : ((fieldTypeMapping = this.loaderAssist.getFieldTypeMapping(entity.getName(), field.getName())) == null ? DataType.getDefaultMySqlDataType(column.getColumnTypeDefinition()) : DataType.getDataType(fieldTypeMapping.dataType)));
        string = fieldTypeMapping == null ? dataType.getName() : fieldTypeMapping.dataType;
        string2 = fieldTypeMapping == null || fieldTypeMapping.codeType == null ? dataType.getDefaultCodeType() : fieldTypeMapping.codeType;
        dataSourceEngine = this.loaderAssist.getDataSourceEngine();
        if (dataSourceEngine == Constants.DataSourceEngine.MY_SQL) {
            dataSourceFieldType = DataSourceFieldType.createMySqlInstance(column.getColumnTypeDefinition());
        }
        typeDetails = new Field.TypeDetails(string, string2);
        typeDetails.addDataSourceFieldType(dataSourceEngine, dataSourceFieldType);
        return typeDetails;
    }

    private void addSystemFields(Entity entity) throws Exception {
        Constants.DataSourceEngine dataSourceEngine = null;
        Map map = null;
        dataSourceEngine = this.loaderAssist.getDataSourceEngine();
        if (dataSourceEngine == Constants.DataSourceEngine.MY_SQL) {
            this.addSystemField(entity, dataSourceEngine, "TinyInt", SystemFieldType.find("RecordStatus"), null);
            this.addSystemField(entity, dataSourceEngine, "Int", SystemFieldType.find("RecordVersion_WholeNumber"), null);
            this.addSystemField(entity, dataSourceEngine, "BigInt", SystemFieldType.find("AuditCreateUserId"), null);
            map = CollectionUtils.getOrderedMap(new HashMap(2));
            map.put("timezone", "IMPLICIT");
            map.put("timezone-additional", "0");
            this.addSystemField(entity, dataSourceEngine, "BigInt", SystemFieldType.find("AuditCreateTimestamp"), map);
            this.addSystemField(entity, dataSourceEngine, "BigInt", SystemFieldType.find("AuditUpdateUserId"), null);
            map = CollectionUtils.getOrderedMap(new HashMap(2));
            map.put("timezone", "IMPLICIT");
            map.put("timezone-additional", "0");
            this.addSystemField(entity, dataSourceEngine, "BigInt", SystemFieldType.find("AuditUpdateTimestamp"), map);
        }
    }

    private void addSystemField(Entity entity, Constants.DataSourceEngine dataSourceEngine, String string, SystemFieldType systemFieldType, Map<String, String> map) {
        Field.TypeDetails typeDetails = null;
        SystemField systemField = null;
        typeDetails = new Field.TypeDetails(systemFieldType.getDataType(dataSourceEngine, string), systemFieldType.getCodeType(dataSourceEngine, string));
        typeDetails.addDataSourceFieldType(dataSourceEngine, DataSourceFieldType.createMySqlInstance(string));
        typeDetails.setParameters(map);
        systemField = new SystemField(systemFieldType, 0L, systemFieldType.getDefaultFieldName(), systemFieldType.getDefaultPersistenceName(), "");
        new DefaultValue("${none}", systemField);
        systemField.setTypeDetails(typeDetails);
        entity.addSystemField(systemField);
    }

    private void addEntityOperationsConfiguration(Entity entity) throws Exception {
        EntityOperationsConfiguration entityOperationsConfiguration = null;
        entityOperationsConfiguration = new EntityOperationsConfiguration();
        entityOperationsConfiguration.addSupportedOperation(Constants.EntityOperation.LIST);
        entityOperationsConfiguration.addSupportedOperation(Constants.EntityOperation.GET);
        entityOperationsConfiguration.addSupportedOperation(Constants.EntityOperation.CREATE);
        entityOperationsConfiguration.addSupportedOperation(Constants.EntityOperation.UPDATE);
        entityOperationsConfiguration.addSupportedOperation(Constants.EntityOperation.DELETE);
        entityOperationsConfiguration.setSupportsListWhereClause(true);
        for (Field field : entity.getFields()) {
            entityOperationsConfiguration.addListReturnField(field.getName());
            entityOperationsConfiguration.addGetReturnField(field.getName());
        }
        entity.setEntityOperationsConfiguration(entityOperationsConfiguration);
    }

    private void addBusinessObjects(Repository repository) throws Exception {
        BusinessObject businessObject = null;
        BusinessObjectOperation businessObjectOperation = null;
        businessObject = new BusinessObject("Authenticator", "");
        businessObjectOperation = new BusinessObjectOperation("Authenticate", "");
        businessObjectOperation.addProtocol("HTTPS");
        businessObjectOperation.addParameter(new BusinessObjectOperation.Parameter("LogonDetails", "LogonDetails"));
        businessObject.addOperation(businessObjectOperation);
        repository.addBusinessObject(businessObject);
        businessObject = new BusinessObject("Transaction", "");
        businessObjectOperation = new BusinessObjectOperation("Transact", "");
        businessObjectOperation.addProtocol("HTTP");
        businessObjectOperation.addProtocol("HTTPS");
        businessObjectOperation.addParameter(new BusinessObjectOperation.Parameter("EntityList", "EntityList"));
        businessObject.addOperation(businessObjectOperation);
        repository.addBusinessObject(businessObject);
    }

    private void addSecurityConfiguration(SystemConfiguration systemConfiguration, Repository repository) throws Exception {
        SecurityConfiguration securityConfiguration = null;
        ArrayList<SystemRole> arrayList = null;
        Permission permission = null;
        BusinessObjectPermission businessObjectPermission = null;
        EntityPermission entityPermission = null;
        EntityPermissionSecurityClause entityPermissionSecurityClause = null;
        securityConfiguration = new SecurityConfiguration();
        repository.setSecurityConfiguration(securityConfiguration);
        arrayList = new ArrayList<SystemRole>(1);
        arrayList.add(systemConfiguration.getSystemRole("Anyone"));
        permission = new Permission(++idCounter, arrayList);
        businessObjectPermission = new BusinessObjectPermission("Authenticator");
        businessObjectPermission.addSupportedOperation("Authenticate");
        permission.addBusinessObjectPermission(businessObjectPermission);
        securityConfiguration.addPermission(permission, systemConfiguration);
        arrayList = new ArrayList(1);
        arrayList.add(systemConfiguration.getSystemRole("AuthenticatedUser"));
        permission = new Permission(++idCounter, arrayList);
        businessObjectPermission = new BusinessObjectPermission("Transaction");
        businessObjectPermission.addSupportedOperation("Transact");
        permission.addBusinessObjectPermission(businessObjectPermission);
        securityConfiguration.addPermission(permission, systemConfiguration);
        permission = new Permission(++idCounter, systemConfiguration.getSystemRoles());
        securityConfiguration.addPermission(permission, systemConfiguration);
        for (Entity entity : repository.getSortedEntityList()) {
            entityPermission = new EntityPermission(++idCounter, entity.getName());
            entityPermissionSecurityClause = new EntityPermissionSecurityClause(++idCounter, "default");
            entityPermission.addSecurityClause(entityPermissionSecurityClause, entity);
            entityPermissionSecurityClause.addSupportedOperation(Constants.EntityOperation.LIST);
            entityPermissionSecurityClause.addSupportedOperation(Constants.EntityOperation.GET);
            entityPermissionSecurityClause.addSupportedOperation(Constants.EntityOperation.CREATE);
            entityPermissionSecurityClause.addSupportedOperation(Constants.EntityOperation.UPDATE);
            entityPermissionSecurityClause.addSupportedOperation(Constants.EntityOperation.DELETE);
            for (Field field : entity.getFields()) {
                entityPermissionSecurityClause.addReadField(field.getName());
            }
            for (Field field : entity.getFields()) {
                if (field.getName().equals("Id")) continue;
                entityPermissionSecurityClause.addUpdateField(field.getName());
            }
            for (Field field : entity.getFields()) {
                if (field.getName().equals("Id")) continue;
                entityPermissionSecurityClause.addCreateField(field.getName());
            }
            permission.addEntityPermission(entityPermission);
        }
    }

    private static String getDefaultValue(String string) {
        String string2 = null;
        string2 = string == null ? "${none}" : (string.toLowerCase().indexOf("null") >= 0 ? "${null}" : string);
        return string2;
    }

    static {
        SYSTEM_FIELDS.add("RECORD_STATUS");
        SYSTEM_FIELDS.add("RECORD_VERSION");
        SYSTEM_FIELDS.add("CREATE_USER_ID");
        SYSTEM_FIELDS.add("CREATE_USERNAME");
        SYSTEM_FIELDS.add("CREATE_TIMESTAMP");
        SYSTEM_FIELDS.add("UPDATE_USER_ID");
        SYSTEM_FIELDS.add("UPDATE_USERNAME");
        SYSTEM_FIELDS.add("UPDATE_TIMESTAMP");
    }

    public static class PersistenceNameConverterImpl
    implements PersistenceNameConverter {
        private Constants.DataSourceEngine dataSourceEngine;

        private PersistenceNameConverterImpl(Constants.DataSourceEngine dataSourceEngine) {
            this.dataSourceEngine = dataSourceEngine;
        }

        public String covertTableName(String string) {
            String string2 = null;
            string2 = this.dataSourceEngine == Constants.DataSourceEngine.MY_SQL ? string.toUpperCase() : string;
            return string2;
        }

        public String covertColumnName(String string) {
            return string;
        }
    }
}

