/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.systemconfiguration;

import com.jronimo.systemconfiguration.Constants;
import com.jronimo.systemconfiguration.EntityPermissionSecurityClause;
import com.jronimo.systemconfiguration.SecurityClauseSet;
import com.jronimo.util.Logger;
import java.util.HashMap;
import java.util.Map;

public class SystemRole {
    private static final Logger logger = Logger.getLogger(SystemRole.class);
    private Long id;
    private String name;
    private Map<String, EntitySecurityInformation> entitySecurityInformations = new HashMap<String, EntitySecurityInformation>();
    private Map<String, SecurityClauseSet> entitySecurityClauseSets = new HashMap<String, SecurityClauseSet>();

    public SystemRole(Long l, String string) {
        this.id = l;
        this.name = string;
    }

    public synchronized void addSecurityClause(String string, EntityPermissionSecurityClause entityPermissionSecurityClause) {
        this.addSecurityClauseToEntitySecurityInformations(string, entityPermissionSecurityClause);
    }

    private void addSecurityClauseToEntitySecurityInformations(String string, EntityPermissionSecurityClause entityPermissionSecurityClause) {
        EntitySecurityInformation entitySecurityInformation = null;
        entitySecurityInformation = this.entitySecurityInformations.get(string);
        if (entitySecurityInformation == null) {
            entitySecurityInformation = new EntitySecurityInformation();
            this.entitySecurityInformations.put(string, entitySecurityInformation);
        }
        entitySecurityInformation.addSecurityClause(entityPermissionSecurityClause);
    }

    private void addSecurityClauseToEntitySecurityClauses(String string, EntityPermissionSecurityClause entityPermissionSecurityClause) {
        SecurityClauseSet securityClauseSet = null;
        securityClauseSet = this.entitySecurityClauseSets.get(string);
        if (securityClauseSet == null) {
            securityClauseSet = new SecurityClauseSet();
            this.entitySecurityClauseSets.put(string, securityClauseSet);
        }
        securityClauseSet.add(entityPermissionSecurityClause);
    }

    public Long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public boolean hasEntityAccess(String string) {
        return this.entitySecurityInformations.keySet().contains(string);
    }

    public SecurityClauseSet getSecurityClauseSet(String string, Constants.EntityOperation entityOperation) {
        return this.entitySecurityInformations.get(string).getSecurityClauseSet(entityOperation);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object object) {
        boolean bl = false;
        SystemRole systemRole = null;
        if (object instanceof SystemRole) {
            systemRole = (SystemRole)object;
            if (systemRole.name.equals(this.name)) {
                bl = true;
            }
        }
        return bl;
    }

    private static class EntitySecurityInformation {
        private Map<Constants.EntityOperation, SecurityClauseSet> operationSecurityClauses = new HashMap<Constants.EntityOperation, SecurityClauseSet>(5);

        private EntitySecurityInformation() {
        }

        void addSecurityClause(EntityPermissionSecurityClause entityPermissionSecurityClause) {
            SecurityClauseSet securityClauseSet = null;
            for (Constants.EntityOperation entityOperation : entityPermissionSecurityClause.getSupportedOperations()) {
                securityClauseSet = this.operationSecurityClauses.get((Object)entityOperation);
                if (securityClauseSet == null) {
                    securityClauseSet = new SecurityClauseSet();
                    this.operationSecurityClauses.put(entityOperation, securityClauseSet);
                }
                securityClauseSet.add(entityPermissionSecurityClause);
            }
        }

        SecurityClauseSet getSecurityClauseSet(Constants.EntityOperation entityOperation) {
            return this.operationSecurityClauses.get((Object)entityOperation);
        }
    }
}

