/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.systemconfiguration;

import com.jronimo.collections.collection.CollectionUtils;
import com.jronimo.systemconfiguration.BusinessObject;
import com.jronimo.systemconfiguration.DataSource;
import com.jronimo.systemconfiguration.Entity;
import com.jronimo.systemconfiguration.RefDataCategory;
import com.jronimo.systemconfiguration.Relationship;
import com.jronimo.systemconfiguration.SecurityConfiguration;
import com.jronimo.systemconfiguration.TextGroup;
import com.jronimo.util.Logger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Repository {
    private static final Logger logger = Logger.getLogger(Repository.class);
    private Collection<DataSource> dataSources = new ArrayList<DataSource>(1);
    private Map<String, Entity> entities = CollectionUtils.getOrderedMap(new HashMap(100));
    private Collection<Relationship> relationships = new ArrayList<Relationship>(100);
    private Map<String, BusinessObject> businessObjects = CollectionUtils.getOrderedMap(new HashMap(10));
    private Collection<TextGroup> textGroups = new ArrayList<TextGroup>(100);
    private Collection<RefDataCategory> refDataCategories = new ArrayList<RefDataCategory>(100);
    private SecurityConfiguration securityConfiguration;

    public void setDataSources(Collection<DataSource> collection) {
        this.dataSources = collection;
    }

    public Collection<DataSource> getDataSources() {
        return this.dataSources;
    }

    public void addEntity(Entity entity) {
        this.entities.put(entity.getName(), entity);
    }

    public Map<String, Entity> getEntities() {
        return this.entities;
    }

    public Entity getEntity(String string) {
        return this.entities.get(string);
    }

    public List<Entity> getSortedEntityList() {
        ArrayList<Entity> arrayList = null;
        List list = null;
        list = CollectionUtils.setToList(this.entities.keySet());
        Collections.sort(list);
        arrayList = new ArrayList<Entity>(list.size());
        for (String string : list) {
            arrayList.add(this.entities.get(string));
        }
        return arrayList;
    }

    public void addRelationship(Relationship relationship) {
        this.relationships.add(relationship);
    }

    public Collection<Relationship> getRelationships() {
        return this.relationships;
    }

    public void addBusinessObject(BusinessObject businessObject) {
        this.businessObjects.put(businessObject.getIdentifier(), businessObject);
    }

    public Collection<BusinessObject> getBusinessObjects() {
        return this.businessObjects.values();
    }

    public BusinessObject getBusinessObject(String string) {
        return this.businessObjects.get(string);
    }

    public void addTextGroup(TextGroup textGroup) {
        this.textGroups.add(textGroup);
    }

    public Collection<TextGroup> getTextGroups() {
        return this.textGroups;
    }

    public void addRefDataCategory(RefDataCategory refDataCategory) {
        this.refDataCategories.add(refDataCategory);
    }

    public Collection<RefDataCategory> getRefDataCategories() {
        return this.refDataCategories;
    }

    public void setSecurityConfiguration(SecurityConfiguration securityConfiguration) {
        this.securityConfiguration = securityConfiguration;
    }

    public SecurityConfiguration getSecurityConfiguration() {
        return this.securityConfiguration;
    }
}

