/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.systemconfiguration;

import com.jronimo.engines.dataservice.Constants;
import com.jronimo.util.Logger;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RefDataItem {
    private static final Logger logger = Logger.getLogger(RefDataItem.class);
    private Long id;
    private String identifier;
    private String valueTextIdentifier;
    private String status;
    private List<PropertyStruct> properties = new ArrayList<PropertyStruct>(5);

    public RefDataItem(Long l, String string, String string2, String string3) {
        this.id = l;
        this.identifier = string;
        this.valueTextIdentifier = string2;
        this.status = string3;
    }

    public Long getId() {
        return this.id;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String getValueTextIdentifier() {
        return this.valueTextIdentifier;
    }

    public String getStatus() {
        return this.status;
    }

    public boolean isActive() {
        return this.status.equals((Object)Constants.Status.ACTIVE);
    }

    public boolean isExpired() {
        return this.status.equals((Object)Constants.Status.EXPIRED);
    }

    public boolean isHidden() {
        return this.status.equals((Object)Constants.Status.HIDDEN);
    }

    public boolean isDeleted() {
        return this.status.equals((Object)Constants.Status.DELETED);
    }

    public void addProperty(PropertyStruct propertyStruct) {
        this.properties.add(propertyStruct);
    }

    public boolean hasProperty(String string) {
        return this.getProperty(string) != null;
    }

    public List<PropertyStruct> getProperties() {
        return this.properties;
    }

    public PropertyStruct getProperty(String string) {
        PropertyStruct propertyStruct = null;
        for (PropertyStruct propertyStruct2 : this.properties) {
            if (!propertyStruct2.name.equals(string)) continue;
            propertyStruct = propertyStruct2;
            break;
        }
        return propertyStruct;
    }

    public int hashCode() {
        return this.identifier.hashCode();
    }

    public boolean equals(Object object) {
        boolean bl = false;
        RefDataItem refDataItem = null;
        if (object instanceof RefDataItem) {
            refDataItem = (RefDataItem)object;
            if (refDataItem.identifier.equals(this.identifier)) {
                bl = true;
            }
        }
        return bl;
    }

    public static class PropertyStruct {
        public String name;
        public String value;
    }
}

