/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.systemconfiguration;

import com.jronimo.engines.dataservice.Constants;
import com.jronimo.systemconfiguration.RefDataItem;
import com.jronimo.util.Logger;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RefDataCategory {
    private static final Logger logger = Logger.getLogger(RefDataCategory.class);
    private Long id;
    private String identifier;
    private String parentIdentifier;
    private String displayTextIdentifier;
    private String status;
    private List<PropertyStruct> properties = new ArrayList<PropertyStruct>(5);
    private List<RefDataItem> refDataItems = new ArrayList<RefDataItem>(10);

    public RefDataCategory(Long l, String string, String string2, String string3, String string4) {
        this.id = l;
        this.identifier = string;
        this.parentIdentifier = string2;
        this.displayTextIdentifier = string3;
        this.status = string4;
    }

    public Long getId() {
        return this.id;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String getParentIdentifier() {
        return this.parentIdentifier;
    }

    public String getDisplayTextIdentifier() {
        return this.displayTextIdentifier;
    }

    public String getStatus() {
        return this.status;
    }

    public boolean isActive() {
        return this.status.equals((Object)Constants.Status.ACTIVE);
    }

    public boolean isExpired() {
        return this.status.equals((Object)Constants.Status.EXPIRED);
    }

    public boolean isHidden() {
        return this.status.equals((Object)Constants.Status.HIDDEN);
    }

    public boolean isDeleted() {
        return this.status.equals((Object)Constants.Status.DELETED);
    }

    public void addRefDataItem(RefDataItem refDataItem) {
        this.refDataItems.add(refDataItem);
    }

    public List<RefDataItem> getRefDataItems() {
        return this.refDataItems;
    }

    public void addProperty(PropertyStruct propertyStruct) {
        this.properties.add(propertyStruct);
    }

    public List<PropertyStruct> getProperties() {
        return this.properties;
    }

    public int hashCode() {
        return this.identifier.hashCode();
    }

    public boolean equals(Object object) {
        boolean bl = false;
        RefDataCategory refDataCategory = null;
        if (object instanceof RefDataCategory) {
            refDataCategory = (RefDataCategory)object;
            if (refDataCategory.identifier.equals(this.identifier)) {
                bl = true;
            }
        }
        return bl;
    }

    public static class PropertyStruct {
        public String name;
        public String type;
    }
}

