/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.systemconfiguration;

import com.jronimo.collections.collection.CollectionUtils;
import com.jronimo.systemconfiguration.Constants;
import com.jronimo.systemconfiguration.Entity;
import com.jronimo.systemconfiguration.Field;
import com.jronimo.util.Logger;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrimaryKey {
    private static final Logger logger = Logger.getLogger(PrimaryKey.class);
    private Constants.PrimaryKeyType type;
    private String sequenceName;
    private List<String> fieldNames = new ArrayList<String>(1);

    public PrimaryKey(Constants.PrimaryKeyType primaryKeyType, String string) {
        this.type = primaryKeyType;
        this.sequenceName = string;
    }

    public Constants.PrimaryKeyType getType() {
        return this.type;
    }

    public String getSequenceName() {
        return this.sequenceName;
    }

    public void addFieldName(String string) {
        this.fieldNames.add(string);
    }

    public List<String> getFieldNames() {
        return this.fieldNames;
    }

    public int getFieldCount() {
        return this.fieldNames.size();
    }

    public Field getSingleField(Entity entity) {
        Field field = null;
        field = entity.getField(this.getSingleFieldName());
        return field;
    }

    public String getSingleFieldName() {
        String string;
        block0: {
            String string2;
            string = null;
            Iterator<String> iterator = this.fieldNames.iterator();
            if (!iterator.hasNext()) break block0;
            string = string2 = iterator.next();
        }
        return string;
    }

    public Set<Field> getFields(Entity entity) {
        Set set = null;
        set = CollectionUtils.getOrderedSet(new HashSet(this.fieldNames.size()));
        for (String string : this.fieldNames) {
            set.add(entity.getField(string));
        }
        return set;
    }

    public boolean isPrimaryKeyField(String string) {
        return this.fieldNames.contains(string);
    }

    public boolean isSequence() {
        return this.type == Constants.PrimaryKeyType.SEQUENCE;
    }

    public boolean isAutoNumber() {
        return this.type == Constants.PrimaryKeyType.AUTO_NUMBER;
    }

    public boolean isCompoundImmutable() {
        return this.type == Constants.PrimaryKeyType.USER_ENTERED_IMMUTABLE;
    }

    public boolean isCompoundMutable() {
        return this.type == Constants.PrimaryKeyType.USER_ENTERED_MUTABLE;
    }
}

