/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.systemconfiguration;

import com.jronimo.collections.collection.CollectionUtils;
import com.jronimo.exceptions.UnexpectedErrorException;
import com.jronimo.systemconfiguration.DatabaseType;
import com.jronimo.util.Logger;
import com.jronimo.util.Methods;
import com.jronimo.xml.XmlElement;
import com.jronimo.xml.XmlElementFactory;
import java.util.HashMap;
import java.util.Map;

public final class MySqlType
extends DatabaseType {
    private static final Logger logger = Logger.getLogger(MySqlType.class);
    protected static Map<String, MySqlType> types;

    private MySqlType(String string, String string2, String string3, String string4, String string5, boolean bl, boolean bl2, boolean bl3, boolean bl4, String string6) {
        super(string, string2, string3, string4, string5, bl, bl2, bl3, bl4, string6);
    }

    public boolean isTinyInt() {
        return this.getName().equals("TINYINT");
    }

    public boolean isSmallInt() {
        return this.getName().equals("SMALLINT");
    }

    public boolean isInt() {
        return this.getName().equals("INT");
    }

    public boolean isBigInt() {
        return this.getName().equals("BIGINT");
    }

    public boolean isFloat() {
        return this.getName().equals("FLOAT");
    }

    public boolean isDouble() {
        return this.getName().equals("DOUBLE");
    }

    public boolean isDecimal() {
        return this.getName().equals("DECIMAL");
    }

    public boolean isChar() {
        return this.getName().equals("CHAR");
    }

    public boolean isVarChar() {
        return this.getName().equals("VARCHAR");
    }

    public boolean isTinyText() {
        return this.getName().equals("TINYTEXT");
    }

    public boolean isText() {
        return this.getName().equals("TEXT");
    }

    public boolean isMediumText() {
        return this.getName().equals("MEDIUMTEXT");
    }

    public boolean isLongText() {
        return this.getName().equals("LONGTEXT");
    }

    public boolean isVarBinary() {
        return this.getName().equals("VARBINARY");
    }

    public boolean isTinyBlob() {
        return this.getName().equals("TINYBLOB");
    }

    public boolean isBlob() {
        return this.getName().equals("BLOB");
    }

    public boolean isMediumBlob() {
        return this.getName().equals("MEDIUMBLOB");
    }

    public boolean isLongBlob() {
        return this.getName().equals("LONGBLOB");
    }

    public boolean isDate() {
        return this.getName().equals("DATE");
    }

    public boolean isDateTime() {
        return this.getName().equals("DATETIME");
    }

    public boolean isTime() {
        return this.getName().equals("TIME");
    }

    public static MySqlType find(String string) {
        return types.get(string);
    }

    private static void load() {
        Map map = null;
        XmlElement xmlElement = null;
        MySqlType mySqlType = null;
        try {
            map = CollectionUtils.getOrderedMap(new HashMap(21));
            xmlElement = XmlElementFactory.load(Methods.getClassPathResourceAsStream(MySqlType.class, "MySqlTypes.xml"));
            for (XmlElement xmlElement2 : xmlElement.getOptionalElements("type")) {
                mySqlType = MySqlType.loadType(xmlElement2);
                map.put(mySqlType.getName(), mySqlType);
            }
            types = map;
        }
        catch (Exception exception) {
            throw new UnexpectedErrorException(exception);
        }
    }

    private static MySqlType loadType(XmlElement xmlElement) {
        MySqlType mySqlType = null;
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        String string6 = null;
        string = xmlElement.getText("name");
        string2 = xmlElement.getText("broad-type");
        string3 = xmlElement.getText("sql-type");
        string4 = xmlElement.getText("range-start");
        string5 = xmlElement.getText("range-end");
        bl = xmlElement.getOptionalBoolean("supports-capacity", "false");
        bl2 = xmlElement.getOptionalBoolean("supports-precision-scale", "false");
        bl3 = xmlElement.getOptionalBoolean("supports-character-set", "false");
        bl4 = xmlElement.getOptionalBoolean("supports-collation", "false");
        string6 = xmlElement.getOptionalText("comments", "");
        mySqlType = new MySqlType(string, string2, string3, string4, string5, bl, bl2, bl3, bl4, string6);
        return mySqlType;
    }

    static {
        MySqlType.load();
    }
}

