/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.systemconfiguration;

import com.jronimo.collections.collection.CollectionUtils;
import com.jronimo.systemconfiguration.Constants;
import com.jronimo.systemconfiguration.DataSourceFieldType;
import com.jronimo.systemconfiguration.DataType;
import com.jronimo.systemconfiguration.DefaultValue;
import com.jronimo.util.Logger;
import java.util.HashMap;
import java.util.Map;

public class Field {
    private static final Logger logger = Logger.getLogger(Field.class);
    private Long id;
    private String name;
    private String persistenceIdentifier;
    private String comments;
    private DefaultValue defaultValue;
    private TypeDetails typeDetails;

    public Field(Long l, String string, String string2, String string3) {
        this.id = l;
        this.name = string;
        this.persistenceIdentifier = string2;
        this.comments = string3;
    }

    public boolean isSystemField() {
        return false;
    }

    public Long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.name;
    }

    public String getPersistenceIdentifier() {
        return this.persistenceIdentifier;
    }

    void setDefaultValue(DefaultValue defaultValue) {
        this.defaultValue = defaultValue;
    }

    public boolean hasDefaultValue() {
        return !this.defaultValue.isNone();
    }

    public DefaultValue getDefaultValue() {
        return this.defaultValue;
    }

    public String getComments() {
        return this.comments;
    }

    public void setTypeDetails(TypeDetails typeDetails) {
        this.typeDetails = typeDetails;
    }

    public TypeDetails getTypeDetails() {
        return this.typeDetails;
    }

    public DataType.BroadType getBroadType() {
        return this.typeDetails.getBroadType();
    }

    public DataType getDataType() {
        return this.typeDetails.getDataType();
    }

    public Constants.CodeType getCodeType() {
        return this.typeDetails.getCodeType();
    }

    public DataSourceFieldType getDataSourceFieldType(Constants.DataSourceEngine dataSourceEngine) {
        return this.typeDetails.getDataSourceFieldType(dataSourceEngine);
    }

    public boolean supportsCapacity(Constants.DataSourceEngine dataSourceEngine) {
        return this.typeDetails.getDataSourceFieldType(dataSourceEngine).supportsCapacity();
    }

    public boolean hasCapacity(Constants.DataSourceEngine dataSourceEngine) {
        return this.typeDetails.getDataSourceFieldType(dataSourceEngine).hasCapacity();
    }

    public Integer getCapacity(Constants.DataSourceEngine dataSourceEngine) {
        return this.typeDetails.getDataSourceFieldType(dataSourceEngine).getCapacity();
    }

    public String getParameter(String string) {
        return this.typeDetails.getParameter(string);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object object) {
        boolean bl = false;
        Field field = null;
        if (object instanceof Field) {
            field = (Field)object;
            bl = field.name.equals(this.name);
        }
        return bl;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TypeDetails {
        private DataType dataType;
        private Constants.CodeType codeType;
        private Map<Constants.DataSourceEngine, DataSourceFieldType> dataSourceFieldTypes = CollectionUtils.getOrderedMap(new HashMap(2));
        private Map<String, String> parameters;

        public TypeDetails(String string, String string2) {
            this.dataType = DataType.getDataType(string);
            this.codeType = Constants.CodeType.get(string2);
        }

        public TypeDetails(DataType dataType, Constants.CodeType codeType) {
            this.dataType = dataType;
            this.codeType = codeType;
        }

        public DataType getDataType() {
            return this.dataType;
        }

        public Constants.CodeType getCodeType() {
            return this.codeType;
        }

        public void addDataSourceFieldType(Constants.DataSourceEngine dataSourceEngine, DataSourceFieldType dataSourceFieldType) {
            this.dataSourceFieldTypes.put(dataSourceEngine, dataSourceFieldType);
        }

        public Map<Constants.DataSourceEngine, DataSourceFieldType> getDataSourceFieldTypes() {
            return this.dataSourceFieldTypes;
        }

        public DataSourceFieldType getDataSourceFieldType(Constants.DataSourceEngine dataSourceEngine) {
            return this.dataSourceFieldTypes.get((Object)dataSourceEngine);
        }

        public void setParameters(Map<String, String> map) {
            this.parameters = map;
        }

        public Map<String, String> getParameters() {
            return this.parameters;
        }

        public String getParameter(String string) {
            return this.parameters.get(string);
        }

        public DataType.BroadType getBroadType() {
            return this.dataType.getBroadType();
        }
    }
}

