/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.systemconfiguration;

import com.jronimo.collections.collection.CollectionUtils;
import com.jronimo.systemconfiguration.Constants;
import com.jronimo.util.Logger;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityOperationsConfiguration {
    private static final Logger logger = Logger.getLogger(EntityOperationsConfiguration.class);
    private Set<Constants.EntityOperation> supportedOperations = CollectionUtils.getOrderedSet(new HashSet(5));
    private boolean supportsListWhereClause;
    private Set<String> readHiddenFields = CollectionUtils.getOrderedSet(new HashSet(3));
    private Set<String> writeHiddenFields = CollectionUtils.getOrderedSet(new HashSet(8));
    private Set<String> lazyFields = CollectionUtils.getOrderedSet(new HashSet(5));
    private Set<String> listReturnFields = CollectionUtils.getOrderedSet(new HashSet(10));
    private Set<String> getReturnFields = CollectionUtils.getOrderedSet(new HashSet(10));

    public void addSupportedOperation(Constants.EntityOperation entityOperation) {
        this.supportedOperations.add(entityOperation);
    }

    public Set<Constants.EntityOperation> getSupportedOperations() {
        return this.supportedOperations;
    }

    public boolean supportsOperation(Constants.EntityOperation entityOperation) {
        return this.supportedOperations.contains((Object)entityOperation);
    }

    public boolean supportsList() {
        return this.supportedOperations.contains((Object)Constants.EntityOperation.LIST);
    }

    public boolean supportsGet() {
        return this.supportedOperations.contains((Object)Constants.EntityOperation.GET);
    }

    public boolean supportsCreate() {
        return this.supportedOperations.contains((Object)Constants.EntityOperation.CREATE);
    }

    public boolean supportsUpdate() {
        return this.supportedOperations.contains((Object)Constants.EntityOperation.UPDATE);
    }

    public boolean supportsDelete() {
        return this.supportedOperations.contains((Object)Constants.EntityOperation.DELETE);
    }

    public void setSupportsListWhereClause(boolean bl) {
        this.supportsListWhereClause = bl;
    }

    public boolean supportsListWhereClause() {
        return this.supportsListWhereClause;
    }

    public void addReadHiddenField(String string) {
        this.readHiddenFields.add(string);
    }

    public Set<String> getReadHiddenFields() {
        return this.readHiddenFields;
    }

    public boolean isReadHiddenField(String string) {
        return this.readHiddenFields.contains(string);
    }

    public void addWriteHiddenField(String string) {
        this.writeHiddenFields.add(string);
    }

    public Set<String> getWriteHiddenFields() {
        return this.writeHiddenFields;
    }

    public boolean isWriteHiddenField(String string) {
        return this.writeHiddenFields.contains(string);
    }

    public void addLazyField(String string) {
        this.lazyFields.add(string);
    }

    public Set<String> getLazyFields() {
        return this.lazyFields;
    }

    public boolean isLazyField(String string) {
        return this.lazyFields.contains(string);
    }

    public void addListReturnField(String string) {
        this.listReturnFields.add(string);
    }

    public Set<String> getListReturnFields() {
        return this.listReturnFields;
    }

    public boolean isListReturnField(String string) {
        return this.listReturnFields.contains(string);
    }

    public void addGetReturnField(String string) {
        this.getReturnFields.add(string);
    }

    public Set<String> getGetReturnFields() {
        return this.getReturnFields;
    }

    public boolean isGetReturnField(String string) {
        return this.getReturnFields.contains(string);
    }

    public static void loadDefaultConfiguration(EntityOperationsConfiguration entityOperationsConfiguration) {
        entityOperationsConfiguration.addSupportedOperation(Constants.EntityOperation.LIST);
        entityOperationsConfiguration.addSupportedOperation(Constants.EntityOperation.GET);
        entityOperationsConfiguration.addSupportedOperation(Constants.EntityOperation.CREATE);
        entityOperationsConfiguration.addSupportedOperation(Constants.EntityOperation.UPDATE);
        entityOperationsConfiguration.addSupportedOperation(Constants.EntityOperation.DELETE);
        entityOperationsConfiguration.setSupportsListWhereClause(true);
    }
}

