/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.systemconfiguration;

import com.jronimo.collections.collection.CollectionUtils;
import com.jronimo.systemconfiguration.Constants;
import com.jronimo.systemconfiguration.ConstraintSet;
import com.jronimo.systemconfiguration.EntityOperationsConfiguration;
import com.jronimo.systemconfiguration.Field;
import com.jronimo.systemconfiguration.Key;
import com.jronimo.systemconfiguration.PrimaryKey;
import com.jronimo.systemconfiguration.SystemField;
import com.jronimo.util.Logger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Entity
implements Comparable<Entity> {
    private static final Logger logger = Logger.getLogger(Entity.class);
    private Long id;
    private String name;
    private String persistenceIdentifier;
    private DataSource dataSource;
    private String comments;
    private Map<String, Field> fields = CollectionUtils.getOrderedMap(new HashMap(10));
    private PrimaryKey primaryKey;
    private Collection<Key> keys = new ArrayList<Key>(2);
    private Set<SystemField> systemFields = CollectionUtils.getOrderedSet(new HashSet(6));
    private EntityOperationsConfiguration entityOperationsConfiguration;
    private Set<String> securityClauseFieldNames = CollectionUtils.getOrderedSet(new HashSet(1));
    private Set<String> securityClauseSystemFieldNames = CollectionUtils.getOrderedSet(new HashSet(1));
    private Map<String, ConstraintSet> constraintSets = CollectionUtils.getOrderedMap(new HashMap(1));

    public Entity(Long l, String string, String string2, String string3) {
        this.id = l;
        this.name = string;
        this.persistenceIdentifier = string2;
        this.comments = string3;
    }

    public Long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getPersistenceIdentifier() {
        return this.persistenceIdentifier;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public String getComments() {
        return this.comments;
    }

    public void addField(Field field) {
        this.fields.put(field.getName(), field);
    }

    public Set<Field> getFields() {
        Set set = null;
        set = CollectionUtils.getOrderedSet(new HashSet(this.fields.size()));
        for (Field field : this.fields.values()) {
            set.add(field);
        }
        return set;
    }

    public Field getField(String string) {
        return this.fields.get(string);
    }

    public void setPrimaryKey(PrimaryKey primaryKey) {
        this.primaryKey = primaryKey;
    }

    public PrimaryKey getPrimaryKey() {
        return this.primaryKey;
    }

    public boolean isPrimaryKeyField(String string) {
        return this.primaryKey.isPrimaryKeyField(string);
    }

    public void addKey(Key key) {
        this.keys.add(key);
    }

    public Collection<Key> getKeys() {
        return this.keys;
    }

    public void addSystemField(SystemField systemField) {
        this.systemFields.add(systemField);
    }

    public Set<SystemField> getSystemFields() {
        return this.systemFields;
    }

    public boolean isSystemField(String string) {
        return this.getSystemField(string) != null;
    }

    public SystemField getSystemField(String string) {
        SystemField systemField = null;
        for (SystemField systemField2 : this.systemFields) {
            if (!systemField2.getName().equals(string)) continue;
            systemField = systemField2;
            break;
        }
        return systemField;
    }

    public boolean hasRecordStatusSystemField() {
        boolean bl = false;
        for (SystemField systemField : this.systemFields) {
            if (!systemField.isRecordStatusField()) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public SystemField getRecordStatusSystemField() {
        SystemField systemField = null;
        for (SystemField systemField2 : this.systemFields) {
            if (!systemField2.isRecordStatusField()) continue;
            systemField = systemField2;
            break;
        }
        return systemField;
    }

    public boolean hasRecordVersionSystemField() {
        boolean bl = false;
        for (SystemField systemField : this.systemFields) {
            if (!systemField.isRecordVersionField()) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public SystemField getRecordVersionSystemField() {
        SystemField systemField = null;
        for (SystemField systemField2 : this.systemFields) {
            if (!systemField2.isRecordVersionField()) continue;
            systemField = systemField2;
            break;
        }
        return systemField;
    }

    public boolean hasCreateUserSystemField() {
        boolean bl = false;
        for (SystemField systemField : this.systemFields) {
            if (!systemField.isCreateUserField()) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public SystemField getCreateUserSystemField() {
        SystemField systemField = null;
        for (SystemField systemField2 : this.systemFields) {
            if (!systemField2.isCreateUserField()) continue;
            systemField = systemField2;
            break;
        }
        return systemField;
    }

    public boolean hasCreateTimestampSystemField() {
        boolean bl = false;
        for (SystemField systemField : this.systemFields) {
            if (!systemField.isCreateTimestampField()) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public SystemField getCreateTimestampSystemField() {
        SystemField systemField = null;
        for (SystemField systemField2 : this.systemFields) {
            if (!systemField2.isCreateTimestampField()) continue;
            systemField = systemField2;
            break;
        }
        return systemField;
    }

    public boolean hasUpdateUserSystemField() {
        boolean bl = false;
        for (SystemField systemField : this.systemFields) {
            if (!systemField.isUpdateUserField()) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public SystemField getUpdateUserSystemField() {
        SystemField systemField = null;
        for (SystemField systemField2 : this.systemFields) {
            if (!systemField2.isUpdateUserField()) continue;
            systemField = systemField2;
            break;
        }
        return systemField;
    }

    public boolean hasUpdateTimestampSystemField() {
        boolean bl = false;
        for (SystemField systemField : this.systemFields) {
            if (!systemField.isUpdateTimestampField()) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public SystemField getUpdateTimestampSystemField() {
        SystemField systemField = null;
        for (SystemField systemField2 : this.systemFields) {
            if (!systemField2.isUpdateTimestampField()) continue;
            systemField = systemField2;
            break;
        }
        return systemField;
    }

    public void setEntityOperationsConfiguration(EntityOperationsConfiguration entityOperationsConfiguration) {
        this.entityOperationsConfiguration = entityOperationsConfiguration;
    }

    public EntityOperationsConfiguration getEntityOperationsConfiguration() {
        return this.entityOperationsConfiguration;
    }

    public void addSecurityClauseFieldNames(String string) {
        if (!string.equals("default")) {
            // empty if block
        }
    }

    public Set<Field> getSecurityClauseFields() {
        Set set = null;
        set = CollectionUtils.getOrderedSet(new HashSet(this.securityClauseFieldNames.size()));
        for (String string : this.securityClauseFieldNames) {
            set.add(this.getField(string));
        }
        return set;
    }

    public Set<SystemField> getSecurityClauseSystemFields() {
        Set set = null;
        set = CollectionUtils.getOrderedSet(new HashSet(this.securityClauseSystemFieldNames.size()));
        for (String string : this.securityClauseSystemFieldNames) {
            set.add(this.getSystemField(string));
        }
        return set;
    }

    public boolean supportsOperation(Constants.EntityOperation entityOperation) {
        return this.entityOperationsConfiguration.supportsOperation(entityOperation);
    }

    public boolean supportsListWhereClause() {
        return this.entityOperationsConfiguration.supportsListWhereClause();
    }

    public Set<String> getListReturnFields() {
        return this.entityOperationsConfiguration.getListReturnFields();
    }

    public Set<String> getGetReturnFields() {
        return this.entityOperationsConfiguration.getGetReturnFields();
    }

    public void addConstraintSet(ConstraintSet constraintSet) {
        this.constraintSets.put(constraintSet.getName(), constraintSet);
    }

    public Map<String, ConstraintSet> getConstraintSets() {
        return this.constraintSets;
    }

    public ConstraintSet getConstraintSet(String string) {
        return this.constraintSets.get(string);
    }

    @Override
    public int compareTo(Entity entity) {
        return this.name.compareTo(entity.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object object) {
        boolean bl = false;
        Entity entity = null;
        if (object instanceof Entity) {
            entity = (Entity)object;
            if (entity.name.equals(this.name)) {
                bl = true;
            }
        }
        return bl;
    }

    public static class DataSource {
        public String name;
        public String schema;
    }
}

