/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.systemconfiguration;

import com.jronimo.engines.dataservice.FieldValue;
import com.jronimo.systemconfiguration.DataSourceFieldType;
import com.jronimo.systemconfiguration.Field;
import com.jronimo.systemconfiguration.Methods;
import com.jronimo.text.ResourceTextIdentifiers;
import com.jronimo.text.ResourceTextPointer;
import com.jronimo.util.Assert;
import com.jronimo.util.Logger;

public class DefaultValue {
    private static final Logger logger = Logger.getLogger(DefaultValue.class);
    public static final String NONE = "${none}";
    public static final String NULL = "${null}";
    private String value;
    private Field field;
    private FieldValue fieldValue;

    public DefaultValue(String string, Field field) {
        Assert.errorParam(string == null, new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_NOT_BE_NULL, "value"));
        Assert.errorParam(field == null, new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_NOT_BE_NULL, "field"));
        this.value = string;
        this.field = field;
        this.fieldValue = this.createFieldValue(string, field);
        field.setDefaultValue(this);
    }

    public String getValue() {
        return this.value;
    }

    public synchronized FieldValue getFieldValue(DataSourceFieldType dataSourceFieldType) {
        Assert.errorParam(dataSourceFieldType == null, new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_NOT_BE_NULL, "dataSourceFieldType"));
        return this.fieldValue.setDataSourceFieldType(dataSourceFieldType);
    }

    public boolean isNone() {
        return this.value.equals(NONE);
    }

    public boolean isNull() {
        return this.value.equals(NONE);
    }

    private FieldValue createFieldValue(String string, Field field) {
        FieldValue fieldValue = null;
        String string2 = null;
        if (!string.equals(NONE)) {
            fieldValue = Methods.createNowValue(string, field);
            string2 = fieldValue == null ? string : fieldValue.getCodeValue().toString();
            fieldValue = FieldValue.createInstanceFromStringValue(field.getDataType(), field.getCodeType(), null, string2);
        }
        return fieldValue;
    }
}

