/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.systemconfiguration;

import com.jronimo.temporal.Date;
import com.jronimo.temporal.DateTime;
import com.jronimo.temporal.StringFormat;
import com.jronimo.temporal.Time;
import com.jronimo.temporal.TimeOfDay;
import com.jronimo.util.Logger;
import com.jronimo.util.StringWrapper;
import java.math.BigDecimal;

public abstract class DatabaseType {
    private static final Logger logger = Logger.getLogger(DatabaseType.class);
    public static final String BROAD_TYPE_WHOLE_NUMBER = "WholeNumber";
    public static final String BROAD_TYPE_DECIMAL_NUMBER = "DecimalNumber";
    public static final String BROAD_TYPE_TEXT = "Text";
    public static final String BROAD_TYPE_BINARY = "Binary";
    public static final String BROAD_TYPE_BOOLEAN = "Boolean";
    public static final String BROAD_TYPE_TEMPORAL = "Temporal";
    private String name;
    private String broadType;
    private String sqlType;
    private String rangeStart;
    private String rangeEnd;
    private boolean supportsCapacity;
    private boolean supportsPrecisionScale;
    private boolean supportsCharacterSet;
    private boolean supportsCollation;
    private String comments;

    protected DatabaseType(String string, String string2, String string3, String string4, String string5, boolean bl, boolean bl2, boolean bl3, boolean bl4, String string6) {
        this.name = string;
        this.broadType = string2;
        this.sqlType = string3;
        this.rangeStart = string4;
        this.rangeEnd = string5;
        this.supportsCapacity = bl;
        this.supportsPrecisionScale = bl2;
        this.supportsCharacterSet = bl3;
        this.supportsCollation = bl4;
        this.comments = string6;
    }

    public String getName() {
        return this.name;
    }

    public String getBroadType() {
        return this.broadType;
    }

    public String getSqlType() {
        return this.sqlType;
    }

    public String getRangeStart() {
        return this.rangeStart;
    }

    public String getRangeEnd() {
        return this.rangeEnd;
    }

    public boolean supportsCapacity() {
        return this.supportsCapacity;
    }

    public boolean supportsPrecisionScale() {
        return this.supportsPrecisionScale;
    }

    public boolean supportsCharacterSet() {
        return this.supportsCharacterSet;
    }

    public boolean supportsCollation() {
        return this.supportsCollation;
    }

    public String getComments() {
        return this.comments;
    }

    public boolean isBroadTypeWholeNumber() {
        return this.broadType.equals(BROAD_TYPE_WHOLE_NUMBER);
    }

    public boolean isBroadTypeDecimalNumber() {
        return this.broadType.equals(BROAD_TYPE_DECIMAL_NUMBER);
    }

    public boolean isBroadTypeText() {
        return this.broadType.equals(BROAD_TYPE_TEXT);
    }

    public boolean isBroadTypeBinary() {
        return this.broadType.equals(BROAD_TYPE_BINARY);
    }

    public boolean isBroadTypeBoolean() {
        return this.broadType.equals(BROAD_TYPE_BOOLEAN);
    }

    public boolean isBroadTypeTemporal() {
        return this.broadType.equals(BROAD_TYPE_TEMPORAL);
    }

    public String getDirectSqlValue(Object object) {
        String string = null;
        boolean bl = false;
        StringWrapper stringWrapper = null;
        if (object == null) {
            string = "NULL";
        } else if (object instanceof Boolean) {
            string = object.toString().toUpperCase();
        } else if (object instanceof BigDecimal) {
            string = ((BigDecimal)object).toPlainString();
        } else if (object instanceof Date) {
            string = ((Date)object).getString(new StringFormat(new StringFormat.TimezoneFormat()));
            bl = true;
        } else if (object instanceof DateTime) {
            string = ((DateTime)object).getString(new StringFormat(new StringFormat.TimezoneFormat()));
            bl = true;
        } else if (object instanceof TimeOfDay) {
            string = ((TimeOfDay)object).getString(new StringFormat(new StringFormat.TimezoneFormat()));
            bl = true;
        } else if (object instanceof String || object instanceof Time) {
            string = object.toString();
            bl = true;
        } else {
            string = object.toString();
        }
        stringWrapper = new StringWrapper(string).sqlEscape();
        if (bl) {
            stringWrapper.surround("'");
        }
        string = stringWrapper.toString();
        return string;
    }

    public int hashCode() {
        int n = 17;
        n = n * 37 + this.name.hashCode();
        return n;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        DatabaseType databaseType = null;
        if (object instanceof DatabaseType) {
            databaseType = (DatabaseType)object;
            bl = this.name.equals(databaseType.name);
        }
        return bl;
    }

    public String toString() {
        return this.name;
    }
}

