/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.systemconfiguration;

import com.jronimo.systemconfiguration.DatabaseType;
import com.jronimo.systemconfiguration.MySqlType;
import com.jronimo.util.Logger;

public final class DataSourceFieldType {
    private static final Logger logger = Logger.getLogger(DataSourceFieldType.class);
    private DatabaseType underlyingType;
    private String persistenceDefinition;
    private Integer capacity;

    private DataSourceFieldType(DatabaseType databaseType, String string) {
        this.underlyingType = databaseType;
        this.persistenceDefinition = string;
        this.setCapacity();
    }

    private void setCapacity() {
        int n = 0;
        int n2 = 0;
        if (this.underlyingType.supportsCapacity() && (n = this.persistenceDefinition.indexOf("(")) >= 0) {
            n2 = this.persistenceDefinition.indexOf(")");
            this.capacity = Integer.valueOf(this.persistenceDefinition.substring(n + 1, n2));
        }
    }

    public static DataSourceFieldType createMySqlInstance(String string) {
        return new DataSourceFieldType(MySqlType.find(DataSourceFieldType.extractType(string)), string);
    }

    private static String extractType(String string) {
        String string2 = null;
        int n = 0;
        string2 = string.toUpperCase();
        n = string2.indexOf("(");
        if (n >= 0) {
            string2 = string2.substring(0, n);
        } else {
            n = string2.indexOf(" ");
            if (n >= 0) {
                string2 = string2.substring(0, n);
            }
        }
        return string2;
    }

    public DatabaseType getUnderlyingType() {
        return this.underlyingType;
    }

    public String getPersistenceDefinition() {
        return this.persistenceDefinition;
    }

    public boolean supportsCapacity() {
        return this.underlyingType.supportsCapacity();
    }

    public boolean hasCapacity() {
        return this.capacity != null;
    }

    public Integer getCapacity() {
        return this.capacity;
    }

    public boolean isMySqlType() {
        return this.underlyingType instanceof MySqlType;
    }

    public int hashCode() {
        int n = 17;
        n = n * 37 + this.underlyingType.hashCode();
        n = n * 37 + this.persistenceDefinition.hashCode();
        return n;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        DataSourceFieldType dataSourceFieldType = null;
        if (object instanceof DataSourceFieldType) {
            dataSourceFieldType = (DataSourceFieldType)object;
            bl = this.underlyingType.equals(dataSourceFieldType.underlyingType) && this.persistenceDefinition.equals(dataSourceFieldType.persistenceDefinition);
        }
        return bl;
    }

    public String toString() {
        return this.persistenceDefinition;
    }
}

