/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.swing;

import com.jronimo.swing.ComponentFactory;
import com.jronimo.swing.GuiMethods;
import com.jronimo.swing.Popup;
import com.jronimo.util.Logger;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public final class UserInputPopup
extends JDialog
implements Popup {
    private static final Logger logger = Logger.getLogger(UserInputPopup.class);
    private JLabel label;
    private JTextField textField;
    private ButtonPanel buttonPanel;
    private Object result;

    public UserInputPopup(JFrame jFrame, String string, boolean bl, String string2, String string3, int n) {
        super(jFrame, string, bl);
        this.init(jFrame, string2, string3, n);
    }

    public UserInputPopup(JDialog jDialog, String string, boolean bl, String string2, String string3, int n) {
        super(jDialog, string, bl);
        this.init(jDialog, string2, string3, n);
    }

    private void init(Container container, String string, String string2, int n) {
        this.initializeEventHandlers();
        this.initializeComponents(string, string2, n);
        this.initializeContainers(container);
    }

    private void initializeEventHandlers() {
    }

    private void initializeComponents(String string, String string2, int n) {
        this.label = ComponentFactory.getLabel(string);
        this.textField = ComponentFactory.getTextField(string2, true);
        this.textField.setPreferredSize(new Dimension(n, this.textField.getPreferredSize().height));
        this.buttonPanel = new ButtonPanel();
    }

    private void initializeContainers(Container container) {
        GridBagLayout gridBagLayout = null;
        GridBagConstraints gridBagConstraints = null;
        JComponent jComponent = null;
        gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        gridBagConstraints = new GridBagConstraints();
        jComponent = this.label;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        gridBagLayout.setConstraints(jComponent, gridBagConstraints);
        this.add(jComponent);
        jComponent = this.textField;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 10000.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(10, 0, 10, 10);
        gridBagLayout.setConstraints(jComponent, gridBagConstraints);
        this.add(jComponent);
        jComponent = this.buttonPanel;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 10001.0;
        gridBagConstraints.weighty = 1000.0;
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.anchor = 14;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(10, 20, 20, 10);
        gridBagLayout.setConstraints(jComponent, gridBagConstraints);
        this.add(jComponent);
        this.pack();
        if (container != null) {
            GuiMethods.centerPopup(container, this);
        }
    }

    public void disableAll() {
    }

    public void enableAll() {
    }

    private void okButton() {
        this.hide();
        this.result = this.textField.getText().trim();
        if (((String)this.result).length() == 0) {
            this.result = null;
        }
    }

    private void cancelButton() {
        this.hide();
    }

    public Object getResult(boolean bl) {
        Object object = null;
        object = this.result;
        if (bl) {
            this.discard();
        }
        return object;
    }

    public void discard() {
        this.dispose();
    }

    public final class ButtonPanel
    extends JPanel {
        private ActionListener okButtonListener = null;
        private ActionListener cancelButtonListener = null;
        private JButton cancelButton = null;
        private JButton okButton = null;

        public ButtonPanel() {
            this.initializeEventHandlers();
            this.initializeComponents();
            this.initializeContainers();
        }

        private void initializeEventHandlers() {
            this.okButtonListener = new OKButtonListener();
            this.cancelButtonListener = new CancelButtonListener();
        }

        private void initializeComponents() {
            this.okButton = new JButton("OK");
            this.cancelButton = new JButton("Cancel");
            this.okButton.addActionListener(this.okButtonListener);
            this.cancelButton.addActionListener(this.cancelButtonListener);
            UserInputPopup.this.getRootPane().setDefaultButton(this.okButton);
        }

        private void initializeContainers() {
            GridLayout gridLayout = null;
            gridLayout = new GridLayout(1, 2);
            gridLayout.setHgap(10);
            this.setLayout(gridLayout);
            this.add(this.okButton);
            this.add(this.cancelButton);
        }

        public class CancelButtonListener
        implements ActionListener {
            private CancelButtonListener() {
            }

            public void actionPerformed(ActionEvent actionEvent) {
                Thread thread = null;
                thread = new Thread(new Runnable(){

                    public void run() {
                        UserInputPopup.this.cancelButton();
                    }
                });
                GuiMethods.startEventThread(thread);
            }
        }

        public class OKButtonListener
        implements ActionListener {
            private OKButtonListener() {
            }

            public void actionPerformed(ActionEvent actionEvent) {
                Thread thread = null;
                thread = new Thread(new Runnable(){

                    public void run() {
                        UserInputPopup.this.okButton();
                    }
                });
                GuiMethods.startEventThread(thread);
            }
        }
    }
}

