/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.swing;

import com.jronimo.util.Logger;
import java.util.Enumeration;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public final class TreeTraverser {
    private static final Logger logger = Logger.getLogger(TreeTraverser.class);
    private JTree tree;
    private DefaultMutableTreeNode node;
    private Listener listener;

    public TreeTraverser(JTree jTree, Listener listener) {
        this(jTree, (DefaultMutableTreeNode)jTree.getModel().getRoot(), listener);
    }

    public TreeTraverser(JTree jTree, DefaultMutableTreeNode defaultMutableTreeNode, Listener listener) {
        this.tree = jTree;
        this.node = defaultMutableTreeNode;
        this.listener = listener;
    }

    public void execute() {
        this.execute(this.node);
        this.fireFinishedEvent();
    }

    private void execute(DefaultMutableTreeNode defaultMutableTreeNode) {
        Enumeration<TreeNode> enumeration = null;
        this.fireNodeEvent(defaultMutableTreeNode);
        enumeration = defaultMutableTreeNode.children();
        while (enumeration.hasMoreElements()) {
            this.execute((DefaultMutableTreeNode)enumeration.nextElement());
        }
    }

    private void fireNodeEvent(DefaultMutableTreeNode defaultMutableTreeNode) {
        this.listener.node(new Event(this.tree, defaultMutableTreeNode));
    }

    private void fireFinishedEvent() {
        this.listener.finished(new Event(this.tree, null));
    }

    public static class Event {
        private JTree tree;
        private DefaultMutableTreeNode node;

        private Event(JTree jTree, DefaultMutableTreeNode defaultMutableTreeNode) {
            this.tree = jTree;
            this.node = defaultMutableTreeNode;
        }

        public JTree getTree() {
            return this.tree;
        }

        public TreeNode getNode() {
            return this.node;
        }

        public TreePath getNodeTreePath() {
            return new TreePath(this.node.getPath());
        }
    }

    public static interface Listener {
        public void node(Event var1);

        public void finished(Event var1);
    }
}

