/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.swing;

import com.jronimo.collections.collection.CollectionUtils;
import com.jronimo.swing.TreeTraverser;
import com.jronimo.util.Logger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TreeState {
    private static final Logger logger = Logger.getLogger(TreeState.class);
    private JTree tree;
    private Collection<DefaultMutableTreeNode> expandedNodes;
    private DefaultMutableTreeNode selectedNode;
    private Collection<String> expandedNodePaths;
    private String selectedNodePath;
    private TreeTraverserListener treeTraverserListener;

    public TreeState(JTree jTree) {
        this(jTree, (DefaultMutableTreeNode)jTree.getModel().getRoot());
    }

    public TreeState(JTree jTree, DefaultMutableTreeNode defaultMutableTreeNode) {
        this.tree = jTree;
        this.init(defaultMutableTreeNode);
    }

    public TreeState(JTree jTree, Collection<String> collection, String string) {
        this.tree = jTree;
        this.expandedNodePaths = collection;
        this.selectedNodePath = string;
    }

    private void init(DefaultMutableTreeNode defaultMutableTreeNode) {
        this.treeTraverserListener = new TreeTraverserListener();
        new TreeTraverser(this.tree, defaultMutableTreeNode, this.treeTraverserListener).execute();
    }

    public Collection<DefaultMutableTreeNode> getExpandedNodes() {
        return this.expandedNodes;
    }

    public DefaultMutableTreeNode getSelectedNode() {
        return this.selectedNode;
    }

    public Collection<String> getExpandedNodePaths() {
        return this.expandedNodePaths;
    }

    public String getSelectedNodePath() {
        return this.selectedNodePath;
    }

    public Struct getStruct() {
        Struct struct = null;
        struct = new Struct();
        struct.expandedNodes = this.expandedNodes;
        struct.selectedNode = this.selectedNode;
        struct.expandedNodePaths = this.expandedNodePaths;
        struct.selectedNodePath = this.selectedNodePath;
        return struct;
    }

    public void apply(boolean bl) {
        TreePath treePath = null;
        for (String string : this.expandedNodePaths) {
            treePath = this.getTreePathForStringPath(string);
            if (treePath == null) continue;
            this.tree.expandPath(treePath);
        }
        if (this.selectedNodePath != null && this.selectedNodePath.length() > 0 && (treePath = this.getTreePathForStringPath(this.selectedNodePath)) != null) {
            this.tree.setSelectionPath(treePath);
            if (bl) {
                this.tree.scrollPathToVisible(treePath);
            }
        }
    }

    private TreePath getTreePathForStringPath(String string) {
        TreePath treePath = null;
        DefaultMutableTreeNode defaultMutableTreeNode = null;
        defaultMutableTreeNode = this.getNode((DefaultMutableTreeNode)this.tree.getModel().getRoot(), this.stringPathToList(string));
        if (defaultMutableTreeNode != null) {
            treePath = new TreePath(defaultMutableTreeNode.getPath());
        }
        return treePath;
    }

    private DefaultMutableTreeNode getNode(DefaultMutableTreeNode defaultMutableTreeNode, List<String> list) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = null;
        String string = null;
        DefaultMutableTreeNode defaultMutableTreeNode3 = null;
        if (list.size() == 0) {
            defaultMutableTreeNode2 = defaultMutableTreeNode;
        } else {
            string = list.get(0);
            list.remove(0);
            defaultMutableTreeNode3 = this.getChildNodeWithName(defaultMutableTreeNode, string);
            if (defaultMutableTreeNode3 != null) {
                defaultMutableTreeNode2 = this.getNode(defaultMutableTreeNode3, list);
            }
        }
        return defaultMutableTreeNode2;
    }

    private DefaultMutableTreeNode getChildNodeWithName(DefaultMutableTreeNode defaultMutableTreeNode, String string) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = null;
        Enumeration<TreeNode> enumeration = null;
        DefaultMutableTreeNode defaultMutableTreeNode3 = null;
        enumeration = defaultMutableTreeNode.children();
        while (enumeration.hasMoreElements()) {
            defaultMutableTreeNode3 = (DefaultMutableTreeNode)enumeration.nextElement();
            if (!defaultMutableTreeNode3.toString().equals(string)) continue;
            defaultMutableTreeNode2 = defaultMutableTreeNode3;
            break;
        }
        return defaultMutableTreeNode2;
    }

    private List<String> stringPathToList(String string) {
        ArrayList<String> arrayList = null;
        String[] stringArray = null;
        stringArray = string.substring(1, string.length() - 1).split(",");
        arrayList = new ArrayList<String>(stringArray.length - 1);
        int n = stringArray.length;
        for (int i = 1; i < n; ++i) {
            arrayList.add(stringArray[i].trim());
        }
        return arrayList;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class TreeTraverserListener
    implements TreeTraverser.Listener {
        private Collection<DefaultMutableTreeNode> expandedNodes = CollectionUtils.getOrderedSet(new HashSet(1));
        private DefaultMutableTreeNode selectedNode;
        private Collection<String> expandedNodePaths = CollectionUtils.getOrderedSet(new HashSet(1));
        private String selectedNodePath = "";

        private TreeTraverserListener() {
        }

        @Override
        public void node(TreeTraverser.Event event) {
            TreePath treePath = null;
            treePath = new TreePath(((DefaultMutableTreeNode)event.getNode()).getPath());
            if (TreeState.this.tree.isExpanded(treePath)) {
                this.handleExpandedNode((DefaultMutableTreeNode)event.getNode());
            }
            if (TreeState.this.tree.getSelectionPath() != null && TreeState.this.tree.getSelectionPath().equals(treePath)) {
                this.selectedNode = (DefaultMutableTreeNode)event.getNode();
                this.selectedNodePath = treePath.toString();
            }
        }

        @Override
        public void finished(TreeTraverser.Event event) {
            TreeState.this.expandedNodes = this.expandedNodes;
            TreeState.this.selectedNode = this.selectedNode;
            TreeState.this.expandedNodePaths = this.expandedNodePaths;
            TreeState.this.selectedNodePath = this.selectedNodePath;
        }

        private void handleExpandedNode(DefaultMutableTreeNode defaultMutableTreeNode) {
            HashSet<DefaultMutableTreeNode> hashSet = null;
            HashSet<String> hashSet2 = null;
            String string = null;
            String string2 = null;
            hashSet = new HashSet<DefaultMutableTreeNode>(1);
            hashSet2 = new HashSet<String>(1);
            string = new TreePath(defaultMutableTreeNode.getPath()).toString();
            for (DefaultMutableTreeNode object : this.expandedNodes) {
                string2 = new TreePath(object.getPath()).toString();
                if (!string.startsWith(string2 = string2.substring(0, string2.length() - 1) + ",")) continue;
                hashSet.add(object);
            }
            for (String string3 : this.expandedNodePaths) {
                string2 = string3.substring(0, string3.length() - 1) + ",";
                if (!string.startsWith(string2)) continue;
                hashSet2.add(string3);
            }
            for (DefaultMutableTreeNode defaultMutableTreeNode2 : hashSet) {
                this.expandedNodes.remove(defaultMutableTreeNode2);
            }
            for (String string4 : hashSet2) {
                this.expandedNodePaths.remove(string4);
            }
            this.expandedNodes.add(defaultMutableTreeNode);
            this.expandedNodePaths.add(string);
        }

        public Collection<DefaultMutableTreeNode> getExpandedNodes() {
            return this.expandedNodes;
        }

        public DefaultMutableTreeNode getSelectedNode() {
            return this.selectedNode;
        }

        public Collection<String> getExpandedNodePaths() {
            return this.expandedNodePaths;
        }

        public String getSelectedNodePath() {
            return this.selectedNodePath;
        }
    }

    public class Struct {
        public Collection<DefaultMutableTreeNode> expandedNodes;
        public DefaultMutableTreeNode selectedNode;
        public Collection<String> expandedNodePaths;
        public String selectedNodePath;
    }
}

