/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.swing;

import com.jronimo.util.Logger;
import com.jronimo.util.Methods;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public final class TreeComponent
extends JTree
implements DragGestureListener,
DragSourceListener,
DropTargetListener {
    private static final Logger logger = Logger.getLogger(TreeComponent.class);
    private static final DataFlavor DATA_FLAVOR = new DataFlavor(TreePath.class, "TreePath");
    private Container outermostParent;
    private DragSource dragSource = null;
    private Node selectedNode;
    private Cursor acceptCursor;
    private Cursor rejectCursor;
    private NodeNotificationThread nodeNotificationThread;
    private boolean isDragging;

    public TreeComponent(Container container, Node node) {
        super((TreeNode)((Object)node), true);
        this.outermostParent = container;
        this.init();
    }

    private void init() {
        DragGestureRecognizer dragGestureRecognizer = null;
        this.dragSource = DragSource.getDefaultDragSource();
        this.dragSource.addDragSourceListener(this);
        dragGestureRecognizer = this.dragSource.createDefaultDragGestureRecognizer(this, 3, this);
        dragGestureRecognizer.setSourceActions(dragGestureRecognizer.getSourceActions() & 0xFFFFFFFB);
        this.addTreeSelectionListener(new TreeSelectionListenerImpl());
        new DropTarget(this, this);
    }

    public boolean isDragging() {
        return this.isDragging;
    }

    public Node findNode(TreePath treePath) {
        return this.findNode((Node)this.getModel().getRoot(), treePath);
    }

    private Node findNode(Node node, TreePath treePath) {
        Node node2 = null;
        Enumeration<TreeNode> enumeration = null;
        if (node.getTreePath().equals(treePath)) {
            node2 = node;
        } else {
            enumeration = ((DefaultMutableTreeNode)((Object)node)).children();
            while (enumeration.hasMoreElements() && (node2 = this.findNode((Node)((Object)enumeration.nextElement()), treePath)) == null) {
            }
        }
        return node2;
    }

    public Node findNode(Object object) {
        Node node = null;
        Enumeration<TreeNode> enumeration = null;
        Node node2 = null;
        enumeration = ((DefaultMutableTreeNode)this.getModel().getRoot()).children();
        while (enumeration.hasMoreElements()) {
            node2 = (Node)((Object)enumeration.nextElement());
            if (node2.getUnderlyingObject() == null || !node2.getUnderlyingObject().equals(object)) continue;
            node = node2;
            break;
        }
        return node;
    }

    private Node getNode(Point point) {
        Node node = null;
        TreePath treePath = null;
        treePath = this.getPathForLocation(point.x, point.y);
        if (treePath != null) {
            node = this.findNode(treePath);
        }
        return node;
    }

    private boolean accepts(Point point) {
        boolean bl = false;
        Node node = null;
        node = this.getNode(point);
        if (node != null) {
            bl = node.acceptsDrop(this.selectedNode);
        }
        return bl;
    }

    private void drop(Point point, int n) {
        Node node = null;
        Action action = null;
        node = this.getNode(point);
        if (node != null && (action = Action.getAction(n)) != null) {
            node.drop(new DropData(action, this.selectedNode));
        }
    }

    private void changeCursor(Point point) {
        Cursor cursor = null;
        cursor = this.accepts(point) ? this.acceptCursor : this.rejectCursor;
        this.setCursor(cursor);
    }

    private Point transformLocation(Point point) {
        return SwingUtilities.convertPoint(this.outermostParent, point, this);
    }

    public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
        if (this.selectedNode != null) {
            if (this.nodeNotificationThread != null) {
                this.nodeNotificationThread.cancel();
            }
            if (dragGestureEvent.getDragAction() == 2) {
                this.acceptCursor = DragSource.DefaultMoveDrop;
                this.rejectCursor = DragSource.DefaultMoveNoDrop;
            } else {
                this.acceptCursor = DragSource.DefaultCopyDrop;
                this.rejectCursor = DragSource.DefaultCopyNoDrop;
            }
            this.dragSource.startDrag(dragGestureEvent, this.acceptCursor, new TransferableData(this.selectedNode.getTreePath()), this);
        }
    }

    public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
    }

    public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
    }

    public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
    }

    public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
        this.changeCursor(this.transformLocation(dragSourceDragEvent.getLocation()));
    }

    public void dragExit(DragSourceEvent dragSourceEvent) {
        this.setCursor(null);
    }

    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
    }

    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
    }

    public void dragExit(DropTargetEvent dropTargetEvent) {
    }

    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
    }

    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        this.drop(dropTargetDropEvent.getLocation(), dropTargetDropEvent.getDropAction());
        this.setCursor(null);
    }

    public class DropData {
        private Action action;
        private Node node;

        private DropData(Action action, Node node) {
            this.action = action;
            this.node = node;
        }

        public Action getAction() {
            return this.action;
        }

        public Node getNode() {
            return this.node;
        }

        public boolean isMove() {
            return this.action == Action.MOVE;
        }

        public boolean isCopy() {
            return this.action == Action.COPY;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Action {
        MOVE,
        COPY;


        static Action getAction(int n) {
            Action action = null;
            switch (n) {
                case 2: {
                    action = MOVE;
                    break;
                }
                case 1: {
                    action = COPY;
                }
            }
            return action;
        }
    }

    public static interface Node {
        public Object getUnderlyingObject();

        public void setText(String var1);

        public void setSelected();

        public TreePath getTreePath();

        public void showContextMenu(MouseEvent var1);

        public boolean containsNode(Node var1);

        public Node getParentNode();

        public boolean acceptsDrop(Node var1);

        public void drop(DropData var1);
    }

    public class TransferableData
    implements Transferable {
        private TreePath treePath;

        private TransferableData(TreePath treePath) {
            this.treePath = treePath;
        }

        public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException {
            TreePath treePath = null;
            if (!this.isDataFlavorSupported(dataFlavor)) {
                throw new UnsupportedFlavorException(dataFlavor);
            }
            treePath = this.treePath;
            return treePath;
        }

        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{DATA_FLAVOR};
        }

        public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
            return DATA_FLAVOR.equals(dataFlavor);
        }
    }

    public class NodeNotificationThread
    extends Thread {
        private Node node;
        private boolean cancelled;

        public NodeNotificationThread(Node node) {
            this.node = node;
        }

        public void run() {
            Thread thread = null;
            Methods.sleep(500L);
            if (this.cancelled) {
                logger.debug("Cancelled!");
            } else {
                thread = new Thread(new Runnable(){

                    public void run() {
                        NodeNotificationThread.this.node.setSelected();
                    }
                });
                SwingUtilities.invokeLater(thread);
            }
        }

        public void cancel() {
            this.cancelled = true;
        }
    }

    public class TreeSelectionListenerImpl
    implements TreeSelectionListener {
        private TreeSelectionListenerImpl() {
        }

        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            if (TreeComponent.this.nodeNotificationThread != null) {
                TreeComponent.this.nodeNotificationThread.cancel();
            }
            TreeComponent.this.selectedNode = (Node)TreeComponent.this.getLastSelectedPathComponent();
            if (TreeComponent.this.selectedNode != null) {
                TreeComponent.this.nodeNotificationThread = new NodeNotificationThread(TreeComponent.this.selectedNode);
                TreeComponent.this.nodeNotificationThread.start();
            }
        }
    }
}

