/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.swing;

import com.jronimo.text.ResourceTextIdentifiers;
import com.jronimo.text.ResourceTextPointer;
import com.jronimo.util.Assert;
import com.jronimo.util.Logger;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.util.Enumeration;
import javax.swing.JDialog;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class GuiMethods {
    private static final Logger logger = Logger.getLogger(GuiMethods.class);

    protected GuiMethods() {
    }

    public static void startEventThread(Thread thread) {
        SwingUtilities.invokeLater(thread);
    }

    public static void centerContainerOnScreen(Container container) {
        Dimension dimension = null;
        dimension = GuiMethods.centerInnerRectangle(Toolkit.getDefaultToolkit().getScreenSize(), new Dimension(container.getWidth(), container.getHeight()));
        container.setLocation((int)dimension.getWidth(), (int)dimension.getHeight());
    }

    public static void centerPopup(Container container, JDialog jDialog) {
        Dimension dimension = null;
        Point point = null;
        dimension = GuiMethods.centerInnerRectangle(container.getSize(), jDialog.getSize());
        point = container.getLocation();
        dimension = new Dimension((int)(dimension.getWidth() + (double)point.x), (int)(dimension.getHeight() + (double)point.y));
        jDialog.setLocation((int)dimension.getWidth(), (int)dimension.getHeight());
    }

    public static Dimension centerInnerRectangle(Dimension dimension, Dimension dimension2) {
        return new Dimension((int)Math.round(dimension.getWidth() / 2.0 - dimension2.getWidth() / 2.0), (int)Math.round(dimension.getHeight() / 2.0 - dimension2.getHeight() / 2.0));
    }

    public static boolean isDescendantNode(DefaultMutableTreeNode defaultMutableTreeNode, DefaultMutableTreeNode defaultMutableTreeNode2) {
        boolean bl = false;
        Assert.errorParam(defaultMutableTreeNode == null, new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_NOT_BE_NULL, "parentNode"));
        if (defaultMutableTreeNode2 != null) {
            bl = GuiMethods.isDescendantNode(defaultMutableTreeNode, new TreePath(defaultMutableTreeNode2.getPath()).toString());
        }
        return bl;
    }

    private static boolean isDescendantNode(DefaultMutableTreeNode defaultMutableTreeNode, String string) {
        boolean bl = false;
        Enumeration<TreeNode> enumeration = null;
        if (new TreePath(defaultMutableTreeNode.getPath()).toString().equals(string)) {
            bl = true;
        } else {
            enumeration = defaultMutableTreeNode.children();
            while (enumeration.hasMoreElements() && !(bl = GuiMethods.isDescendantNode((DefaultMutableTreeNode)enumeration.nextElement(), string))) {
            }
        }
        return bl;
    }

    public static void scrollToLeft(JScrollPane jScrollPane) {
        if (jScrollPane != null && jScrollPane.getHorizontalScrollBar() != null) {
            jScrollPane.getHorizontalScrollBar().setValue(0);
        }
    }

    public static void collapseAll(JTree jTree, DefaultMutableTreeNode defaultMutableTreeNode) {
        Enumeration<TreeNode> enumeration = null;
        enumeration = defaultMutableTreeNode.children();
        while (enumeration.hasMoreElements()) {
            GuiMethods.collapseAll(jTree, (DefaultMutableTreeNode)enumeration.nextElement());
        }
        jTree.collapsePath(new TreePath(defaultMutableTreeNode.getPath()));
    }

    public static void expandAll(JTree jTree, DefaultMutableTreeNode defaultMutableTreeNode) {
        TreePath treePath = null;
        int n = 0;
        Enumeration<TreeNode> enumeration = null;
        treePath = new TreePath(defaultMutableTreeNode.getPath());
        n = jTree.getRowForPath(treePath);
        jTree.expandPath(treePath);
        jTree.scrollPathToVisible(treePath);
        jTree.scrollRowToVisible(n);
        jTree.scrollRowToVisible(n + 1);
        enumeration = defaultMutableTreeNode.children();
        while (enumeration.hasMoreElements()) {
            GuiMethods.expandAll(jTree, (DefaultMutableTreeNode)enumeration.nextElement());
        }
    }
}

