/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseMotionAdapter;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

public class DisabledGlassPane
extends JComponent
implements KeyListener {
    private static final Border MESSAGE_BORDER = new EmptyBorder(10, 10, 10, 10);
    private JLabel message = new JLabel();
    private boolean activated;

    public DisabledGlassPane() {
        this.setOpaque(false);
        Color color = UIManager.getColor("inactiveCaptionBorder");
        Color color2 = new Color(color.getRed(), color.getGreen(), color.getBlue(), 128);
        this.setBackground(color2);
        this.setLayout(new GridBagLayout());
        this.add((Component)this.message, new GridBagConstraints());
        this.message.setOpaque(true);
        this.message.setBorder(MESSAGE_BORDER);
        this.addMouseListener(new MouseAdapter(){});
        this.addMouseMotionListener(new MouseMotionAdapter(){});
        this.addKeyListener(this);
        this.setFocusTraversalKeysEnabled(false);
    }

    protected void paintComponent(Graphics graphics) {
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, this.getSize().width, this.getSize().height);
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        Color color2 = new Color(color.getRGB());
        this.message.setBackground(color2);
    }

    public void keyPressed(KeyEvent keyEvent) {
        keyEvent.consume();
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
        keyEvent.consume();
    }

    public synchronized void activate(String string) {
        if (!this.activated) {
            this.activated = true;
            if (string != null && string.length() > 0) {
                this.message.setVisible(true);
                this.message.setText(string);
                this.message.setForeground(this.getForeground());
            } else {
                this.message.setVisible(false);
            }
            this.setVisible(true);
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.requestFocusInWindow();
        }
    }

    public synchronized void deactivate() {
        if (this.activated) {
            this.activated = false;
            this.setCursor(null);
            this.setVisible(false);
        }
    }
}

