/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.swing;

import com.jronimo.util.Logger;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.plaf.metal.MetalIconFactory;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;

public final class DirectoryBrowser
extends JTree {
    private static final Logger logger = Logger.getLogger(DirectoryBrowser.class);
    private TreeWillExpandListenerImpl treeWillExpandListener = null;
    private File initialDirectory = null;
    private boolean directoriesOnly = false;
    private boolean showHidden = false;
    private Map<String, MutableTreeNode> nodes = null;
    private List filledNodes = null;
    private MutableTreeNode rootNode = null;
    private DefaultTreeModel treeModel = null;
    private DefaultTreeCellRenderer folderIconRenderer = null;

    public DirectoryBrowser(boolean bl, boolean bl2) {
        this(new File("C:/"), bl, bl2);
    }

    public DirectoryBrowser(File file, boolean bl, boolean bl2) {
        this.init(file, bl, bl2);
        this.initializeEventHandlers();
        this.addTreeWillExpandListener(this.treeWillExpandListener);
        this.getSelectionModel().setSelectionMode(1);
        this.setSelectionPath(this.ensureAllSubDirectories(file));
    }

    private void init(File file, boolean bl, boolean bl2) {
        if (file == null) {
            file = new File("C:/");
        }
        this.initialDirectory = file;
        this.directoriesOnly = bl;
        this.showHidden = bl2;
        this.nodes = new HashMap<String, MutableTreeNode>();
        this.filledNodes = new ArrayList();
        this.rootNode = new DefaultMutableTreeNode("My Computer");
        this.treeModel = new DefaultTreeModel(this.rootNode);
        this.folderIconRenderer = new DefaultTreeCellRenderer();
        this.folderIconRenderer.setLeafIcon(new MetalIconFactory.FolderIcon16());
        this.setCellRenderer(this.folderIconRenderer);
        this.initializeEventHandlers();
        this.initializeModel();
        this.setModel(this.treeModel);
        this.addTreeWillExpandListener(this.treeWillExpandListener);
        this.getSelectionModel().setSelectionMode(1);
        this.setSelectionPath(this.ensureAllSubDirectories(file));
    }

    private TreePath ensureAllSubDirectories(File file) {
        TreePath treePath = null;
        ArrayList<File> arrayList = null;
        File file2 = null;
        DefaultMutableTreeNode defaultMutableTreeNode = null;
        arrayList = new ArrayList<File>();
        file2 = file;
        while (true) {
            if ((file2 = file2.getParentFile()) == null) break;
            arrayList.add(0, file2);
        }
        file2 = null;
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            file2 = (File)arrayList.get(i);
            this.insertSubDirectories(file2, (DefaultMutableTreeNode)this.nodes.get(file2.getPath()));
        }
        try {
            defaultMutableTreeNode = (DefaultMutableTreeNode)this.nodes.get(file.getPath());
            treePath = new TreePath(defaultMutableTreeNode.getPath());
            this.scrollPathToVisible(treePath);
            this.expandPath(new TreePath(defaultMutableTreeNode.getPath()));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return treePath;
    }

    private void initializeEventHandlers() {
        this.treeWillExpandListener = new TreeWillExpandListenerImpl();
    }

    private void initializeModel() {
        File[] fileArray = null;
        fileArray = File.listRoots();
        int n = fileArray.length;
        for (int i = 0; i < n; ++i) {
            this.treeModel.insertNodeInto(this.getMutableTreeNode(fileArray[i], fileArray[i].getPath()), this.rootNode, i);
        }
    }

    private MutableTreeNode getMutableTreeNode(File file, String string) {
        DefaultMutableTreeNode defaultMutableTreeNode = null;
        DefaultMutableTreeNode defaultMutableTreeNode2 = null;
        defaultMutableTreeNode = new DefaultMutableTreeNode(string, true);
        defaultMutableTreeNode2 = new DefaultMutableTreeNode(" ");
        this.treeModel.insertNodeInto(defaultMutableTreeNode2, defaultMutableTreeNode, 0);
        this.nodes.put(file.getPath(), defaultMutableTreeNode);
        return defaultMutableTreeNode;
    }

    private String treePathToDirectoryPath(TreePath treePath) {
        StringBuffer stringBuffer = null;
        Object[] objectArray = null;
        boolean bl = false;
        stringBuffer = new StringBuffer();
        objectArray = treePath.getPath();
        int n = objectArray.length;
        for (int i = 1; i < n; ++i) {
            stringBuffer.append(objectArray[i].toString());
            if (i <= 1) continue;
            stringBuffer.append(File.separator);
            bl = true;
        }
        if (bl) {
            stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        }
        return stringBuffer.toString();
    }

    private void insertSubDirectories(File file, DefaultMutableTreeNode defaultMutableTreeNode) {
        String[] stringArray = null;
        ArrayList<File> arrayList = null;
        File file2 = null;
        File file3 = null;
        if (file != null && defaultMutableTreeNode != null) {
            stringArray = new File(file.getPath()).list();
            if (stringArray == null) {
                defaultMutableTreeNode.removeAllChildren();
            } else if (!this.filledNodes.contains(file.getPath())) {
                int n;
                defaultMutableTreeNode.removeAllChildren();
                arrayList = new ArrayList<File>();
                int n2 = stringArray.length;
                for (n = 0; n < n2; ++n) {
                    file3 = null;
                    file2 = new File(file, stringArray[n]);
                    if (file2.isDirectory()) {
                        if (this.showHidden) {
                            file3 = file2;
                        } else if (!file2.isHidden()) {
                            file3 = file2;
                        }
                    }
                    if (file3 == null) continue;
                    arrayList.add(file3);
                }
                n2 = arrayList.size();
                for (n = 0; n < n2; ++n) {
                    file2 = (File)arrayList.get(n);
                    this.treeModel.insertNodeInto(this.getMutableTreeNode(file2, file2.getName()), defaultMutableTreeNode, n);
                }
                this.filledNodes.add(file.getPath());
            }
        }
    }

    public void scrollToSelection() {
        int[] nArray = null;
        nArray = this.getSelectionRows();
        if (nArray.length > 0) {
            this.scrollRowToVisible(nArray[0]);
            try {
                for (int i = 1; i <= 5; ++i) {
                    this.scrollRowToVisible(nArray[0] + i);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public File getSelection() {
        File file = null;
        TreePath treePath = null;
        String string = null;
        treePath = this.getSelectionPath();
        if (treePath != null) {
            string = this.treePathToDirectoryPath(treePath);
            file = new File(string);
        }
        return file;
    }

    public void addDirectory(String string) {
        File file = null;
        File file2 = null;
        if (string != null && string.length() > 0 && (file = this.getSelection()) != null) {
            file2 = new File(file, string);
            file2.mkdirs();
            this.init(file2, this.directoriesOnly, this.showHidden);
            this.setSelectionPath(this.ensureAllSubDirectories(file2));
            this.scrollToSelection();
            this.repaint();
        }
    }

    public class TreeWillExpandListenerImpl
    implements TreeWillExpandListener {
        private TreeWillExpandListenerImpl() {
        }

        public void treeWillExpand(TreeExpansionEvent treeExpansionEvent) {
            TreePath treePath = null;
            String string = null;
            File file = null;
            treePath = treeExpansionEvent.getPath();
            string = DirectoryBrowser.this.treePathToDirectoryPath(treeExpansionEvent.getPath());
            file = new File(string);
            DirectoryBrowser.this.insertSubDirectories(file, (DefaultMutableTreeNode)DirectoryBrowser.this.nodes.get(string));
        }

        public void treeWillCollapse(TreeExpansionEvent treeExpansionEvent) {
        }
    }
}

