/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.swing;

import com.jronimo.swing.DisplayOptions;
import com.jronimo.util.Logger;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import javax.swing.ComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentListener;

public class ComponentFactory {
    private static final Logger logger = Logger.getLogger(ComponentFactory.class);

    protected ComponentFactory() {
    }

    public static JScrollPane getScrollPane(JComponent jComponent, int n, int n2) {
        return ComponentFactory.getScrollPane(jComponent, n, n2, 10);
    }

    public static JScrollPane getScrollPane(JComponent jComponent, int n, int n2, int n3) {
        JScrollPane jScrollPane = null;
        if (n3 < 1) {
            n3 = 1;
        }
        jScrollPane = new JScrollPane(jComponent, n, n2);
        jScrollPane.getVerticalScrollBar().setUnitIncrement(jScrollPane.getVerticalScrollBar().getUnitIncrement() * n3);
        return jScrollPane;
    }

    private static JLabel getBaseLabel(String string) {
        JLabel jLabel = null;
        jLabel = new JLabel(string);
        return jLabel;
    }

    public static JLabel getLabel(String string) {
        JLabel jLabel = null;
        jLabel = ComponentFactory.getBaseLabel(string);
        return jLabel;
    }

    public static JTextField getTextField(String string, boolean bl) {
        JTextField jTextField = null;
        jTextField = ComponentFactory.getTextField(string, null, bl);
        return jTextField;
    }

    public static JTextField getTextField(String string, DocumentListener documentListener, boolean bl) {
        JTextField jTextField = null;
        jTextField = new JTextField(string);
        jTextField.setEnabled(bl);
        jTextField.setMargin(new Insets(2, 0, 2, 0));
        if (documentListener != null) {
            jTextField.getDocument().addDocumentListener(documentListener);
        }
        return jTextField;
    }

    public static JButton getButton(String string, ActionListener actionListener, boolean bl) {
        JButton jButton = null;
        jButton = new JButton(string);
        jButton.setCursor(new Cursor(12));
        jButton.setEnabled(bl);
        if (actionListener != null) {
            jButton.addActionListener(actionListener);
        }
        return jButton;
    }

    public static JButton getImageButton(ImageIcon imageIcon, ActionListener actionListener, boolean bl) {
        JButton jButton = null;
        jButton = new JButton(imageIcon);
        jButton.setCursor(new Cursor(12));
        jButton.setEnabled(bl);
        if (actionListener != null) {
            jButton.addActionListener(actionListener);
        }
        return jButton;
    }

    public static JComboBox getComboBox(ComboBoxModel comboBoxModel, ActionListener actionListener, boolean bl) {
        JComboBox jComboBox = null;
        jComboBox = new JComboBox(comboBoxModel);
        jComboBox.setEnabled(bl);
        jComboBox.setBackground(Color.white);
        if (actionListener != null) {
            jComboBox.addActionListener(actionListener);
        }
        return jComboBox;
    }

    public static JComboBox getComboBox(Object[] objectArray, ActionListener actionListener, boolean bl) {
        JComboBox<Object> jComboBox = null;
        jComboBox = new JComboBox<Object>(objectArray);
        jComboBox.setEnabled(bl);
        jComboBox.setBackground(Color.white);
        if (actionListener != null) {
            jComboBox.addActionListener(actionListener);
        }
        return jComboBox;
    }

    public static JRadioButton getRadioButton(String string, ActionListener actionListener, DisplayOptions.RadioButtonDisplayOptions radioButtonDisplayOptions) {
        JRadioButton jRadioButton = null;
        jRadioButton = new JRadioButton(string);
        switch (radioButtonDisplayOptions) {
            case SHOW_SELECTED: {
                jRadioButton.setSelected(true);
                break;
            }
            case SHOW_UNSELECTED: {
                jRadioButton.setSelected(false);
                break;
            }
            case DISABLE_SELECTED: {
                jRadioButton.setEnabled(false);
                jRadioButton.setSelected(true);
                break;
            }
            case DISABLE_UNSELECTED: {
                jRadioButton.setEnabled(false);
                jRadioButton.setSelected(false);
                break;
            }
            case HIDE: {
                jRadioButton.setVisible(false);
            }
        }
        if (actionListener != null) {
            jRadioButton.addActionListener(actionListener);
        }
        return jRadioButton;
    }

    public static JCheckBox getCheckBox(String string, ItemListener itemListener, DisplayOptions.CheckBoxDisplayOptions checkBoxDisplayOptions) {
        JCheckBox jCheckBox = null;
        jCheckBox = new JCheckBox(string);
        switch (checkBoxDisplayOptions) {
            case SHOW_CHECKED: {
                jCheckBox.setSelected(true);
                break;
            }
            case SHOW_UNCHECKED: {
                jCheckBox.setSelected(false);
                break;
            }
            case DISABLE_CHECKED: {
                jCheckBox.setEnabled(false);
                jCheckBox.setSelected(true);
                break;
            }
            case DISABLE_UNCHECKED: {
                jCheckBox.setEnabled(false);
                jCheckBox.setSelected(false);
                break;
            }
            case HIDE: {
                jCheckBox.setVisible(false);
            }
        }
        if (itemListener != null) {
            jCheckBox.addItemListener(itemListener);
        }
        return jCheckBox;
    }
}

