/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.nameformat;

import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface NameFormat {
    public Format getFormat();

    public String getCamelCase();

    public String getHungarian();

    public String getUpperCase();

    public String getXmlNotation();

    public String getText();

    public int getWordCount();

    public List<String> getDetectedWords();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Format {
        CAMEL_CASE(null),
        HUNGARIAN(null),
        UPPER_CASE(Separator.UNDERSCORE),
        XML_NOTATION(Separator.HYPHEN),
        TEXT(Separator.SPACE);

        private Separator separator;

        private Format(Separator separator) {
            this.separator = separator;
        }

        public boolean hasSeparator() {
            return this.separator != null;
        }

        public Separator getSeparator() {
            return this.separator;
        }

        public boolean isCamelCase() {
            return this == CAMEL_CASE;
        }

        public boolean isHungarian() {
            return this == HUNGARIAN;
        }

        public boolean isUpperCase() {
            return this == UPPER_CASE;
        }

        public boolean isXmlNotation() {
            return this == XML_NOTATION;
        }

        public boolean isText() {
            return this == TEXT;
        }

        public static Format get(String string) {
            Format format = null;
            for (Format format2 : Format.values()) {
                if (!format2.toString().equalsIgnoreCase(string)) continue;
                format = format2;
                break;
            }
            return format;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Separator {
        SPACE(" "),
        UNDERSCORE("_"),
        HYPHEN("-");

        private String character;

        private Separator(String string2) {
            this.character = string2;
        }

        public boolean isSpace() {
            return this == SPACE;
        }

        public boolean isUnderscore() {
            return this == UNDERSCORE;
        }

        public boolean isHyphen() {
            return this == HYPHEN;
        }

        public String getString() {
            return this.character;
        }

        public static Separator get(String string) {
            Separator separator = null;
            for (Separator separator2 : Separator.values()) {
                if (!separator2.character.equals(string)) continue;
                separator = separator2;
                break;
            }
            return separator;
        }

        public static String getSeparators() {
            return SPACE.getString() + UNDERSCORE.getString() + HYPHEN.getString();
        }
    }
}

