/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.messageserver.util;

import com.jronimo.util.Logger;
import com.jronimo.util.NameFormat;

public class Constants
extends com.jronimo.util.Constants {
    private static final Logger logger = Logger.getLogger(Constants.class);
    public static final String GUEST = "Guest";

    protected Constants() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ServerContext {
        DEV(1),
        PREVIEW(2),
        READY(3),
        VERSION(4),
        TEST(5),
        UAT(6),
        STAGING(7),
        LIVE(8);

        private int id;
        private NameFormat nameFormat;

        private ServerContext(int n2) {
            this.id = n2;
            this.nameFormat = new NameFormat(this.toString());
        }

        public int getId() {
            return this.id;
        }

        public boolean isDev() {
            return this == DEV;
        }

        public boolean isPreview() {
            return this == PREVIEW;
        }

        public boolean isReady() {
            return this == READY;
        }

        public boolean isStaging() {
            return this == STAGING;
        }

        public boolean isLive() {
            return this == LIVE;
        }

        public String toXmlNotation() {
            return this.nameFormat.getXmlNotation();
        }

        public static ServerContext match(String string) {
            ServerContext serverContext = null;
            try {
                serverContext = ServerContext.valueOf(new NameFormat(string).getUpperCase());
            }
            catch (Exception exception) {
                // empty catch block
            }
            return serverContext;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum UserAccountStrategy {
        ADMIN,
        USER;

        private NameFormat nameFormat = new NameFormat(this.toString());

        public boolean isAdmin() {
            return this == ADMIN;
        }

        public boolean isUser() {
            return this == USER;
        }

        public NameFormat getNameFormat() {
            return this.nameFormat;
        }

        public String toXmlNotation() {
            return this.nameFormat.getXmlNotation();
        }

        public static UserAccountStrategy match(String string) {
            UserAccountStrategy userAccountStrategy = null;
            try {
                userAccountStrategy = UserAccountStrategy.valueOf(new NameFormat(string).getUpperCase());
            }
            catch (Exception exception) {
                // empty catch block
            }
            return userAccountStrategy;
        }
    }
}

