/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.messageserver.services.useraccount.actions;

import com.jronimo.messageserver.server.facts.active.MessageFacts;
import com.jronimo.messageserver.server.facts.objectmodel.ServerFacts;
import com.jronimo.messageserver.server.model.Action;
import com.jronimo.messageserver.server.model.ActionResult;
import com.jronimo.messageserver.server.model.Issue;
import com.jronimo.messageserver.server.model.UserAccount;
import com.jronimo.util.Logger;
import com.jronimo.util.StringWrapper;
import com.jronimo.xml.XmlElement;
import com.jronimo.xml.XmlElementFactory;

public class Test
implements Action {
    private static final Logger logger = Logger.getLogger(Test.class);
    private MessageFacts messageFacts;
    private ServerFacts serverFacts;
    private XmlElement xmlMessageDetails;

    public Test(MessageFacts messageFacts) {
        this.messageFacts = messageFacts;
        this.serverFacts = messageFacts.getServerFacts();
        this.xmlMessageDetails = messageFacts.getXmlMessage().getOptionalElement("details");
    }

    public ActionResult execute() {
        ActionResult actionResult = new ActionResult();
        String string = null;
        String string2 = null;
        UserAccount userAccount = null;
        XmlElement xmlElement = null;
        if (this.serverFacts.isMaster()) {
            if (this.xmlMessageDetails == null) {
                actionResult.addIssue(Issue.NO_DETAILS);
            } else if (!this.xmlMessageDetails.hasElements("action", "identifier")) {
                actionResult.addIssue(Issue.INCOMPLETE_DETAILS);
            }
            if (!actionResult.hasIssues()) {
                string = this.xmlMessageDetails.getText("action");
                string2 = this.xmlMessageDetails.getText("identifier");
                if (!new StringWrapper(string).equalsAny("Delete", "GetValidationPin")) {
                    actionResult.addIssue(Issue.INCOMPLETE_DETAILS.setDescription("action (" + string + ")"));
                }
                if (!new StringWrapper(string2).equalsAny("testuserone@test.com", "testusertwo@test.com")) {
                    actionResult.addIssue(Issue.INCOMPLETE_DETAILS.setDescription("identifier (" + string2 + ")"));
                }
            }
            if (!actionResult.hasIssues()) {
                userAccount = this.serverFacts.getUserAccounts().getUserAccount(string2);
                if (userAccount == null) {
                    if (string.equals("GetValidationPin")) {
                        actionResult.addIssue(Issue.NOT_FOUND);
                    }
                } else if (string.equals("GetValidationPin") && !userAccount.hasValidationDetails()) {
                    actionResult.addIssue(Issue.UNEXPECTED_STATE);
                }
            }
            if (!actionResult.hasIssues()) {
                xmlElement = XmlElementFactory.create("details");
                if (string.equals("Delete")) {
                    if (userAccount != null) {
                        this.serverFacts.getUserAccounts().deleteUserAccount(userAccount);
                    }
                } else if (string.equals("GetValidationPin")) {
                    xmlElement.addElement("validation-pin").setText(userAccount.getValidationDetails().getPin());
                }
                actionResult.setSuccess(true);
                actionResult.setXmlResponseDetails(xmlElement);
            }
        } else {
            actionResult.addIssue(Issue.INACTIVE_ACTION);
        }
        return actionResult;
    }
}

