/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.messageserver.services.useraccount.actions;

import com.jronimo.messageserver.server.facts.active.MessageFacts;
import com.jronimo.messageserver.server.facts.objectmodel.ServerFacts;
import com.jronimo.messageserver.server.model.Action;
import com.jronimo.messageserver.server.model.ActionResult;
import com.jronimo.messageserver.server.model.Issue;
import com.jronimo.messageserver.server.model.UserAccount;
import com.jronimo.messageserver.services.useraccount.util.Constants;
import com.jronimo.messageserver.services.useraccount.util.Methods;
import com.jronimo.util.Logger;
import com.jronimo.xml.XmlElement;
import com.jronimo.xml.XmlElementFactory;

public class ForgotPassword
implements Action {
    private static final Logger logger = Logger.getLogger(ForgotPassword.class);
    private MessageFacts messageFacts;
    private ServerFacts serverFacts;
    private XmlElement xmlMessageDetails;

    public ForgotPassword(MessageFacts messageFacts) {
        this.messageFacts = messageFacts;
        this.serverFacts = messageFacts.getServerFacts();
        this.xmlMessageDetails = messageFacts.getXmlMessage().getOptionalElement("details");
    }

    public ActionResult execute() {
        ActionResult actionResult = new ActionResult();
        String string = null;
        UserAccount userAccount = null;
        String string2 = null;
        UserAccount.Struct struct = null;
        XmlElement xmlElement = null;
        if (this.serverFacts.isMaster()) {
            if (this.xmlMessageDetails == null) {
                actionResult.addIssue(Issue.NO_DETAILS);
            } else if (!this.xmlMessageDetails.hasElements("identifier")) {
                actionResult.addIssue(Issue.INCOMPLETE_DETAILS);
            }
            if (!actionResult.hasIssues() && !Methods.validateIdentifier(this.serverFacts, string = this.xmlMessageDetails.getText("identifier"))) {
                actionResult.addIssue(Constants.ISSUE_INVALID_IDENTIFIER);
            }
            if (!actionResult.hasIssues()) {
                userAccount = this.serverFacts.getUserAccounts().getUserAccount(string);
                if (userAccount == null) {
                    actionResult.addIssue(Constants.ISSUE_UNRECOGNIZED_IDENTIFIER);
                } else if (!userAccount.isValidated()) {
                    actionResult.addIssue(Constants.ISSUE_NOT_VALIDATED);
                }
            }
            if (!actionResult.hasIssues()) {
                string2 = Methods.getRandomPassword(this.serverFacts);
                struct = new UserAccount.Struct();
                struct.pass = Methods.hashPass(string2);
                struct.resetPassword = true;
                userAccount.setValues(this.serverFacts, struct);
                Methods.sendForgotPasswordEmail(this.messageFacts, userAccount, string2);
                xmlElement = XmlElementFactory.create("details");
                actionResult.setSuccess(true);
                actionResult.setXmlResponseDetails(xmlElement);
            }
        } else {
            actionResult.addIssue(Issue.INACTIVE_ACTION);
        }
        return actionResult;
    }
}

