/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.messageserver.services.useraccount.actions;

import com.jronimo.messageserver.server.facts.active.MessageFacts;
import com.jronimo.messageserver.server.facts.objectmodel.ServerFacts;
import com.jronimo.messageserver.server.model.Action;
import com.jronimo.messageserver.server.model.ActionResult;
import com.jronimo.messageserver.server.model.Issue;
import com.jronimo.messageserver.server.model.UserAccount;
import com.jronimo.messageserver.services.useraccount.util.Constants;
import com.jronimo.messageserver.services.useraccount.util.Methods;
import com.jronimo.util.Logger;
import com.jronimo.xml.XmlElement;
import com.jronimo.xml.XmlElementFactory;

public class Authenticate
implements Action {
    private static final Logger logger = Logger.getLogger(Authenticate.class);
    private MessageFacts messageFacts;
    private ServerFacts serverFacts;
    private XmlElement xmlMessageDetails;

    public Authenticate(MessageFacts messageFacts) {
        this.messageFacts = messageFacts;
        this.serverFacts = messageFacts.getServerFacts();
        this.xmlMessageDetails = messageFacts.getXmlMessage().getOptionalElement("details");
    }

    public ActionResult execute() {
        ActionResult actionResult = new ActionResult();
        String string = null;
        String string2 = null;
        UserAccount userAccount = null;
        XmlElement xmlElement = null;
        if (this.serverFacts.isMaster()) {
            if (this.xmlMessageDetails == null) {
                actionResult.addIssue(Issue.NO_DETAILS);
            } else if (!this.xmlMessageDetails.hasElements("identifier", "pass")) {
                actionResult.addIssue(Issue.INCOMPLETE_DETAILS);
            }
            if (!actionResult.hasIssues()) {
                string = this.xmlMessageDetails.getText("identifier");
                string2 = this.xmlMessageDetails.getText("pass");
                if (!Methods.validateIdentifier(this.serverFacts, string)) {
                    actionResult.addIssue(Constants.ISSUE_INVALID_IDENTIFIER);
                }
                if (!Methods.validatePass(this.serverFacts, string2)) {
                    actionResult.addIssue(Constants.ISSUE_INVALID_PASS);
                }
            }
            if (!actionResult.hasIssues()) {
                userAccount = this.serverFacts.getUserAccounts().getUserAccount(string);
                if (userAccount == null) {
                    actionResult.addIssue(Constants.ISSUE_UNRECOGNIZED_IDENTIFIER);
                } else if (!userAccount.isValidated()) {
                    actionResult.addIssue(Constants.ISSUE_NOT_VALIDATED);
                } else if (userAccount.getResetPassword()) {
                    actionResult.addIssue(Constants.ISSUE_RESET_PASS);
                } else if (!userAccount.hasPass(string2)) {
                    actionResult.addIssue(Constants.ISSUE_UNRECOGNIZED_PASS);
                }
            }
            if (!actionResult.hasIssues()) {
                xmlElement = XmlElementFactory.create("details");
                xmlElement.addElement("auth-bundle").setText(this.serverFacts.getAuthBundles().addAuthBundle(userAccount).toString());
                actionResult.setSuccess(true);
                actionResult.setXmlResponseDetails(xmlElement);
            }
        } else {
            actionResult.addIssue(Issue.INACTIVE_ACTION);
        }
        return actionResult;
    }
}

