/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.messageserver.services.authentication.util;

import com.jronimo.documenter.gui.Methods;
import com.jronimo.messageserver.services.authentication.facts.objectmodel.ServiceFacts;
import com.jronimo.messageserver.services.authentication.util.UserDetailsValidator;
import com.jronimo.messageserver.util.Constants;
import com.jronimo.util.Logger;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserManagedUserDetailsValidator
implements UserDetailsValidator {
    private static final Logger logger = Logger.getLogger(UserManagedUserDetailsValidator.class);

    @Override
    public Constants.UserAccountStrategy getUserAccountStrategy() {
        return Constants.UserAccountStrategy.USER;
    }

    @Override
    public void validateUsername(String string, Collection<String> collection) {
        if (ServiceFacts.getInstance().hasUser(string)) {
            collection.add("Email Address already exists.");
        }
        if (!Methods.validateEmailAddress(string)) {
            collection.add("Email Address does not have a valid format.");
        }
    }

    @Override
    public void validatePassword(String string, Collection<String> collection) {
    }

    public void validateDisplayName(String string, Collection<String> collection) {
        if (string.length() < 2) {
            collection.add("Display Name must be at least two characters in length.");
        }
        if (string.length() > 32) {
            collection.add("Display Name must be no more than 32 characters in length.");
        }
    }
}

