/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.messageserver.services.authentication.loaders;

import com.jronimo.messageserver.services.authentication.facts.objectmodel.ServiceFacts;
import com.jronimo.messageserver.services.authentication.facts.objectmodel.UserFacts;
import com.jronimo.messageserver.services.authentication.util.AdministratorManagedUserDetailsValidator;
import com.jronimo.messageserver.services.authentication.util.UserDetailsValidator;
import com.jronimo.messageserver.services.authentication.util.UserManagedUserDetailsValidator;
import com.jronimo.messageserver.util.Constants;
import com.jronimo.util.Logger;
import com.jronimo.xml.XmlElement;
import com.jronimo.xml.XmlElementFactory;
import java.io.File;
import javax.servlet.ServletConfig;

public class ServerFactsLoader {
    private static final Logger logger = Logger.getLogger(ServerFactsLoader.class);
    private ServletConfig servletConfig;
    private XmlElement xmlConfig;
    private ServiceFacts.Details details = new ServiceFacts.Details();

    private ServerFactsLoader(ServletConfig servletConfig, XmlElement xmlElement) {
        this.servletConfig = servletConfig;
        this.xmlConfig = xmlElement;
    }

    public static ServiceFacts execute(ServletConfig servletConfig, XmlElement xmlElement) {
        return new ServerFactsLoader(servletConfig, xmlElement).execute();
    }

    private ServiceFacts execute() {
        ServiceFacts serviceFacts = null;
        this.details.root = new File((File)this.servletConfig.getServletContext().getAttribute("javax.servlet.context.tempdir"), "NamespaceServer/Authentication");
        this.details.root.mkdir();
        this.details.usersXmlFile = new File(this.details.root, "users.xml");
        this.details.timeoutDuration = this.xmlConfig.getOptionalLong("timeout-duration", "20") * 1000L;
        this.details.userDetailsValidator = this.getUserDetailsValidator();
        this.loadUsers();
        serviceFacts = new ServiceFacts(this.details);
        return serviceFacts;
    }

    private UserDetailsValidator getUserDetailsValidator() {
        UserDetailsValidator userDetailsValidator = null;
        Enum enum_ = null;
        switch (1.$SwitchMap$com$jronimo$messageserver$util$Constants$UserAccountStrategy[enum_.ordinal()]) {
            case 1: {
                userDetailsValidator = new AdministratorManagedUserDetailsValidator();
                break;
            }
            case 2: {
                userDetailsValidator = new UserManagedUserDetailsValidator();
            }
        }
        return userDetailsValidator;
    }

    private void loadUsers() {
        XmlElement xmlElement = null;
        UserFacts userFacts = null;
        xmlElement = XmlElementFactory.load(new File(this.details.root, "users.xml"));
        for (XmlElement xmlElement2 : xmlElement.getOptionalElements("user")) {
            userFacts = new UserFacts(xmlElement2.getOptionalLong("id", "0"), xmlElement2.getText("username"), xmlElement2.getText("password"), xmlElement2.getBoolean("validated"), xmlElement2.getOptionalDateTime("validation-expiry"), xmlElement2.getOptionalText("validation-key"), xmlElement2.getOptionalBoolean("reset-password", "false"));
            this.details.usersById.put(userFacts.getId(), userFacts);
            this.details.usersByIdentifier.put(userFacts.getIdentifier(), userFacts);
        }
    }

    static class 1 {
        static final /* synthetic */ int[] $SwitchMap$com$jronimo$messageserver$util$Constants$UserAccountStrategy;

        static {
            $SwitchMap$com$jronimo$messageserver$util$Constants$UserAccountStrategy = new int[Constants.UserAccountStrategy.values().length];
            try {
                1.$SwitchMap$com$jronimo$messageserver$util$Constants$UserAccountStrategy[Constants.UserAccountStrategy.ADMIN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$com$jronimo$messageserver$util$Constants$UserAccountStrategy[Constants.UserAccountStrategy.USER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }
}

