/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.messageserver.server.util;

import com.jronimo.collections.MutableSet;
import com.jronimo.messageserver.server.util.Issue;
import com.jronimo.util.Logger;
import com.jronimo.xml.XmlElement;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageHandlerResult {
    private static final Logger logger = Logger.getLogger(MessageHandlerResult.class);
    private boolean success;
    private XmlElement xmlResponseMessage;
    private String redirectUrl;
    private boolean appendSessionElement = true;
    private Map<String, String> responseHeaders = new HashMap<String, String>(2);
    private Set<Issue> issues = new MutableSet<Issue>(2);

    public MessageHandlerResult(boolean bl) {
        this.success = bl;
        this.responseHeaders.put("is-message-server-response", "true");
    }

    public boolean getSuccess() {
        return this.success;
    }

    public void setResponseMessage(XmlElement xmlElement) {
        this.xmlResponseMessage = xmlElement;
    }

    public XmlElement getResponseMessage() {
        return this.xmlResponseMessage;
    }

    public boolean hasResponseMessage() {
        return this.xmlResponseMessage != null;
    }

    public void setRedirectUrl(String string) {
        this.redirectUrl = string;
    }

    public String getRedirectUrl() {
        return this.redirectUrl;
    }

    public boolean hasRedirect() {
        return this.redirectUrl != null;
    }

    public void setAppendSessionElement(boolean bl) {
        this.appendSessionElement = bl;
    }

    public boolean getAppendSessionElement() {
        return this.appendSessionElement;
    }

    public void addResponseHeader(String string, String string2) {
        this.responseHeaders.put(string, string2);
    }

    public Map<String, String> getResponseHeaders() {
        return this.responseHeaders;
    }

    public void addIssue(String string) {
        this.issues.add(new Issue(string));
    }

    public void addIssue(Issue issue) {
        this.issues.add(issue);
    }

    public Set<Issue> getIssues() {
        return new MutableSet<Issue>((Collection<Issue>)this.issues);
    }
}

