/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.messageserver.server.processes;

import com.jronimo.messageserver.server.MessageServer;
import com.jronimo.messageserver.server.facts.active.MessageFacts;
import com.jronimo.messageserver.server.facts.objectmodel.ServerFacts;
import com.jronimo.messageserver.server.model.ActionResult;
import com.jronimo.messageserver.server.model.Issue;
import com.jronimo.messageserver.server.model.Session;
import com.jronimo.util.Logger;
import com.jronimo.xml.XmlElement;
import com.jronimo.xml.XmlElementFactory;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessMessage {
    private static final Logger logger = Logger.getLogger(ProcessMessage.class);

    private ProcessMessage() {
    }

    public static MessageServer.Result execute(ServerFacts serverFacts, HttpServletRequest httpServletRequest) throws Exception {
        MessageServer.Result result = new MessageServer.Result();
        MessageFacts messageFacts = null;
        ActionResult actionResult = null;
        boolean bl = false;
        Set<Issue> set = null;
        XmlElement xmlElement = null;
        boolean bl2 = true;
        messageFacts = MessageFacts.createInstance(serverFacts, httpServletRequest);
        if (messageFacts.isValid()) {
            actionResult = messageFacts.getActionInstance().execute();
            bl = actionResult.getSuccess();
            if (!bl) {
                set = actionResult.getIssues();
            }
        } else {
            set = ProcessMessage.assembleIssues(messageFacts);
        }
        if (actionResult != null && actionResult.hasRedirect()) {
            result.redirectUrl = actionResult.getRedirectUrl();
        } else {
            xmlElement = bl ? ProcessMessage.getSuccessMessage(messageFacts, actionResult) : ProcessMessage.getFailureMessage(messageFacts, set);
            if (actionResult != null) {
                bl2 = actionResult.getAppendSessionElement();
            }
            if (bl2) {
                ProcessMessage.appendSession(xmlElement, messageFacts.getSession());
            }
            try {
                result.responseBytes = xmlElement.toString().getBytes("UTF-8");
            }
            catch (Exception exception) {
                logger.warning(exception);
            }
            result.contentType = "application/xml";
            if (actionResult != null) {
                result.responseHeaders = actionResult.getResponseHeaders();
            }
        }
        return result;
    }

    private static XmlElement getSuccessMessage(MessageFacts messageFacts, ActionResult actionResult) {
        XmlElement xmlElement = null;
        xmlElement = ProcessMessage.createResponse(messageFacts, true);
        if (actionResult.hasXmlResponseDetails()) {
            xmlElement.addElement(actionResult.getXmlResponseDetails());
        }
        return xmlElement;
    }

    private static XmlElement getFailureMessage(MessageFacts messageFacts, Set<Issue> set) {
        XmlElement xmlElement = null;
        XmlElement xmlElement2 = null;
        XmlElement xmlElement3 = null;
        xmlElement = ProcessMessage.createResponse(messageFacts, false);
        xmlElement2 = xmlElement.getElement("status").addElement("issues");
        for (Issue issue : set) {
            xmlElement3 = xmlElement2.addElement("issue");
            xmlElement3.addElement("scope").setText(issue.getScope().toString());
            xmlElement3.addElement("code").setText(issue.getCode());
            if (!issue.hasDescription()) continue;
            xmlElement3.addElement("descriptions").setText(issue.getDescription());
        }
        return xmlElement;
    }

    private static XmlElement createResponse(MessageFacts messageFacts, boolean bl) {
        XmlElement xmlElement = null;
        XmlElement xmlElement2 = null;
        xmlElement = XmlElementFactory.create("response");
        xmlElement.addElement("target").setText(messageFacts.getTarget());
        xmlElement2 = xmlElement.addElement("status");
        xmlElement2.addElement("success").setBoolean(bl);
        return xmlElement;
    }

    private static void appendSession(XmlElement xmlElement, Session session) {
        String string = null;
        if (session != null && (string = session.getTopUp()) != null) {
            xmlElement.addElement("session").addElement("interaction-ids").setText(string);
        }
    }

    private static Set<Issue> assembleIssues(MessageFacts messageFacts) {
        HashSet<Issue> hashSet = new HashSet<Issue>(3);
        if (!messageFacts.hasMessage()) {
            ProcessMessage.addIssue(Issue.NO_MESSAGE, hashSet, messageFacts);
        } else if (!messageFacts.hasActionConfig()) {
            ProcessMessage.addIssue(Issue.UNRECOGNIZED_TARGET, hashSet, messageFacts);
        } else if (!messageFacts.getActionConfig().getService().requiresSession() && !messageFacts.hasSession()) {
            ProcessMessage.addIssue(Issue.NO_SESSION, hashSet, messageFacts);
        }
        return hashSet;
    }

    private static void addIssue(Issue issue, Collection<Issue> collection, MessageFacts messageFacts) {
        collection.add(issue);
        logger.warning("(MessageServer)(URI: " + messageFacts.getRequestUri() + ") " + issue.toString());
    }
}

