/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.messageserver.server.model;

import com.jronimo.messageserver.server.facts.objectmodel.ServerFacts;
import com.jronimo.messageserver.server.model.UserAccount;
import com.jronimo.util.BasicFileFilter;
import com.jronimo.util.Logger;
import com.jronimo.xml.XmlElement;
import com.jronimo.xml.XmlElementFactory;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public final class UserAccounts {
    private static final Logger logger = Logger.getLogger(UserAccounts.class);
    private File directory;
    private Map<Long, UserAccount> accountsById = new HashMap<Long, UserAccount>(100);
    private Map<String, UserAccount> accountsByIdentifier = new HashMap<String, UserAccount>(100);

    private UserAccounts(File file) {
        this.directory = file;
    }

    public static UserAccounts createInstance(File file) {
        UserAccounts userAccounts = new UserAccounts(file);
        HashSet<String> hashSet = null;
        BasicFileFilter basicFileFilter = null;
        File[] fileArray = null;
        hashSet = new HashSet<String>(1);
        hashSet.add(".xml");
        basicFileFilter = new BasicFileFilter(true, false, hashSet);
        for (File file2 : fileArray = file.listFiles(basicFileFilter)) {
            UserAccounts.loadUserAccount(userAccounts, file2);
        }
        return userAccounts;
    }

    private static void loadUserAccount(UserAccounts userAccounts, File file) {
        XmlElement xmlElement = null;
        try {
            xmlElement = XmlElementFactory.load(file);
            if (xmlElement == null) {
                UserAccounts.logUserAccountError(file.getName());
            } else {
                userAccounts.addUserAccount(UserAccount.load(xmlElement));
            }
        }
        catch (Exception exception) {
            UserAccounts.logUserAccountError(file.getName());
        }
    }

    private static void logUserAccountError(String string) {
        logger.warning("There was an issue loading a User Account. User Account: " + string);
    }

    public UserAccount createUserAccount(ServerFacts serverFacts, String string, String string2, String string3) {
        UserAccount userAccount = null;
        boolean bl = false;
        UserAccount.ValidationDetails validationDetails = null;
        if (serverFacts.getUserAccountStrategy().isAdmin()) {
            bl = true;
        } else {
            validationDetails = new UserAccount.ValidationDetails();
        }
        userAccount = new UserAccount(serverFacts.getRuntimeConfig().getNextId(), string, string2, string3, bl, validationDetails);
        userAccount.save(serverFacts);
        this.addUserAccount(userAccount);
        return userAccount;
    }

    private void addUserAccount(UserAccount userAccount) {
        this.accountsById.put(userAccount.getId(), userAccount);
        this.accountsByIdentifier.put(userAccount.getIdentifier().toUpperCase(), userAccount);
    }

    public UserAccount getUserAccount(Long l) {
        return this.accountsById.get(l);
    }

    public UserAccount getUserAccount(String string) {
        return this.accountsByIdentifier.get(string.toUpperCase());
    }

    public void resetUserAccountIdentifier(ServerFacts serverFacts, UserAccount userAccount, String string) {
        UserAccount.Struct struct = null;
        this.accountsByIdentifier.remove(userAccount.getIdentifier().toUpperCase());
        struct = new UserAccount.Struct();
        struct.identifier = string;
        struct.requiresValidation = true;
        userAccount.setValues(serverFacts, struct);
        this.accountsByIdentifier.put(userAccount.getIdentifier().toUpperCase(), userAccount);
    }

    public void deleteUserAccount(UserAccount userAccount) {
        File file = null;
        if (userAccount != null) {
            this.accountsById.remove(userAccount.getId());
            this.accountsByIdentifier.remove(userAccount.getIdentifier().toUpperCase());
            file = new File(this.directory, userAccount.getId() + ".xml");
            file.delete();
        }
    }
}

