/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.messageserver.server.loaders;

import com.jronimo.collections.NullFreeImmutableList;
import com.jronimo.messageserver.server.facts.objectmodel.ServerFacts;
import com.jronimo.messageserver.server.model.ActionConfig;
import com.jronimo.messageserver.server.model.AuthBundles;
import com.jronimo.messageserver.server.model.Service;
import com.jronimo.messageserver.server.model.ServiceNamespace;
import com.jronimo.messageserver.server.model.Sessions;
import com.jronimo.messageserver.server.model.UserAccounts;
import com.jronimo.messageserver.server.processes.PrerequisiteTasks;
import com.jronimo.messageserver.util.Methods;
import com.jronimo.util.Logger;
import com.jronimo.util.StringWrapper;
import com.jronimo.xml.XmlElement;
import com.jronimo.xml.XmlElementFactory;
import java.io.File;
import java.net.URL;
import java.util.Collection;
import javax.servlet.ServletConfig;

public class ServerFactsLoader {
    private static final Logger logger = Logger.getLogger(ServerFactsLoader.class);
    private ServletConfig servletConfig;
    private PrerequisiteTasks prerequisiteTasks;
    private ServerFacts.Details details = new ServerFacts.Details();

    private ServerFactsLoader(ServletConfig servletConfig, PrerequisiteTasks prerequisiteTasks) {
        this.servletConfig = servletConfig;
        this.prerequisiteTasks = prerequisiteTasks;
    }

    public static ServerFacts execute(ServletConfig servletConfig, PrerequisiteTasks prerequisiteTasks) {
        return new ServerFactsLoader(servletConfig, prerequisiteTasks).execute();
    }

    private ServerFacts execute() {
        File file = new File(this.prerequisiteTasks.getMessageServerDirectory(), "users");
        ServerFacts serverFacts = null;
        this.details.servletConfig = this.servletConfig;
        this.details.runtimeConfig = this.prerequisiteTasks.getRuntimeConfig();
        this.details.messageServerName = this.prerequisiteTasks.getMessageServerName();
        this.details.isMaster = this.prerequisiteTasks.isMaster();
        this.details.isMinor = this.prerequisiteTasks.isMinor();
        this.details.masterAddress = this.prerequisiteTasks.getMasterAddress();
        this.details.properties = this.prerequisiteTasks.getProperties();
        this.details.messageServerDirectory = this.prerequisiteTasks.getMessageServerDirectory();
        this.details.validationHtml = this.prerequisiteTasks.getValidationHtml();
        this.details.signUpValidationMessage = this.prerequisiteTasks.getSignUpValidationMessage();
        this.details.resetIdentifierValidationMessage = this.prerequisiteTasks.getResetIdentifierValidationMessage();
        if (this.details.isMaster) {
            this.details.userAccounts = UserAccounts.createInstance(file);
        }
        if (this.details.isMaster) {
            this.details.authBundles = new AuthBundles();
        }
        this.details.sessionConfig = this.prerequisiteTasks.getSessionConfig();
        if (this.details.isMinor) {
            this.details.sessions = new Sessions(this.details.sessionConfig);
        }
        serverFacts = new ServerFacts(this.details);
        this.loadConfigFiles();
        return serverFacts;
    }

    private void loadConfigFiles() {
        XmlElement xmlElement = null;
        this.loadConfigFile("com.jronimo.messageserver.server");
        xmlElement = XmlElementFactory.load(Methods.readInitParameterXmlSnippet(this.servletConfig, "messageServerConfig"));
        for (XmlElement xmlElement2 : xmlElement.getOptionalElements("external-configurations/package")) {
            this.loadConfigFile(xmlElement2.getText());
        }
    }

    private void loadConfigFile(String string) {
        URL uRL = null;
        XmlElement xmlElement = null;
        uRL = this.getResource(string);
        if (uRL != null) {
            xmlElement = XmlElementFactory.load(uRL);
            for (XmlElement xmlElement2 : xmlElement.getOptionalElements("services/service")) {
                this.addService(xmlElement2);
            }
        }
    }

    private URL getResource(String string) {
        URL uRL = null;
        StringWrapper stringWrapper = null;
        stringWrapper = new StringWrapper(string).replaceAll(".", "/");
        stringWrapper.deleteLast(stringWrapper.endsWith("/"));
        stringWrapper.append("/MessageServer.xml", !stringWrapper.endsWith("/MessageServer.xml"));
        stringWrapper.insert(0, "/", !stringWrapper.startsWith("/"));
        uRL = this.getClass().getResource(stringWrapper.toString());
        if (uRL == null) {
            logger.warning("A package (" + string + ") cited for a Message Server instance (" + this.prerequisiteTasks.getMessageServerName() + ") could not be found.");
        }
        return uRL;
    }

    private void addService(XmlElement xmlElement) {
        Service service = null;
        service = new Service(xmlElement.getText("name"), xmlElement.getBoolean("requires-session"));
        for (XmlElement xmlElement2 : xmlElement.getOptionalElements("actions/action")) {
            this.loadActionConfig(service, xmlElement2);
        }
        this.getServiceNamespace(xmlElement.getText("namespace")).addService(service);
    }

    private ServiceNamespace getServiceNamespace(String string) {
        ServiceNamespace serviceNamespace = null;
        serviceNamespace = this.details.serviceNamespaces.get(string);
        if (serviceNamespace == null) {
            serviceNamespace = new ServiceNamespace(string);
            this.details.serviceNamespaces.put(string, serviceNamespace);
        }
        return serviceNamespace;
    }

    private void loadActionConfig(Service service, XmlElement xmlElement) {
        String string = null;
        Class<?> clazz = null;
        ActionConfig actionConfig = null;
        string = xmlElement.getText("handler");
        try {
            clazz = Class.forName(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (clazz == null) {
            logger.warning("Could not find action class (" + string + ").");
        } else {
            actionConfig = new ActionConfig(service, xmlElement.getText("name"), clazz, new NullFreeImmutableList<String>((Collection<String>)xmlElement.getOptionalElementsText("roles/role")));
            service.addActionConfig(actionConfig);
        }
    }
}

