/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.messageserver.server.loaders;

import com.jronimo.messageserver.server.facts.active.MessageFacts;
import com.jronimo.messageserver.server.facts.objectmodel.ServerFacts;
import com.jronimo.messageserver.server.model.ActionConfig;
import com.jronimo.messageserver.server.model.Session;
import com.jronimo.messageserver.util.Methods;
import com.jronimo.util.Logger;
import com.jronimo.util.StringWrapper;
import com.jronimo.xml.XmlElement;
import com.jronimo.xml.XmlElementFactory;
import java.io.InputStream;
import javax.servlet.http.HttpServletRequest;

public class MessageFactsLoader {
    private static final Logger logger = Logger.getLogger(MessageFactsLoader.class);
    private ServerFacts serverFacts;
    private HttpServletRequest request;
    private MessageFacts.Details details = new MessageFacts.Details();

    private MessageFactsLoader(ServerFacts serverFacts, HttpServletRequest httpServletRequest) {
        this.serverFacts = serverFacts;
        this.request = httpServletRequest;
    }

    public static MessageFacts execute(ServerFacts serverFacts, HttpServletRequest httpServletRequest) {
        return new MessageFactsLoader(serverFacts, httpServletRequest).execute();
    }

    private MessageFacts execute() {
        MessageFacts messageFacts = null;
        String string = null;
        this.details.serverFacts = this.serverFacts;
        this.details.request = this.request;
        this.details.httpMethod = this.request.getMethod();
        this.details.requestUri = this.request.getRequestURI();
        this.details.contextPath = this.request.getContextPath();
        this.details.additionalPath = this.getAdditionalPath();
        if (this.details.httpMethod.equalsIgnoreCase("post") && (string = this.getBody()) != null) {
            this.details.xmlMessage = XmlElementFactory.load(string);
            this.details.session = this.getSession(this.details.xmlMessage.getOptionalElement("session"));
            this.details.actionConfig = this.getActionConfig(this.details.xmlMessage.getOptionalElement("target"));
        }
        messageFacts = new MessageFacts(this.details);
        return messageFacts;
    }

    private String getBody() {
        String string = null;
        try {
            string = Methods.readFromInputStream((InputStream)this.request.getInputStream());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    private Session getSession(XmlElement xmlElement) {
        Session session = null;
        if (xmlElement != null) {
            session = this.serverFacts.getSessions().getSession(xmlElement.getElement("session"));
        }
        return session;
    }

    private ActionConfig getActionConfig(XmlElement xmlElement) {
        ActionConfig actionConfig = null;
        String string = null;
        String string2 = null;
        String string3 = null;
        if (xmlElement != null) {
            string = xmlElement.getText("namespace");
            string2 = xmlElement.getText("service");
            string3 = xmlElement.getText("action");
            this.details.target = new StringWrapper(string).append(".").append(string2).append(".").append(string3).toString();
            actionConfig = this.serverFacts.getActionConfig(string, string2, string3);
        }
        return actionConfig;
    }

    private String getAdditionalPath() {
        String string = null;
        StringWrapper stringWrapper = null;
        StringWrapper stringWrapper2 = null;
        String string2 = null;
        stringWrapper2 = new StringWrapper(this.request.getContextPath());
        stringWrapper2.deleteFirst(stringWrapper2.startsWith("/"));
        string2 = stringWrapper2.toString();
        stringWrapper = new StringWrapper(this.request.getRequestURI());
        stringWrapper.deleteFirst(stringWrapper.startsWith("/"));
        stringWrapper.deleteFirst(string2);
        stringWrapper.deleteFirst(stringWrapper.startsWith("/"));
        stringWrapper.insert(0, "/");
        stringWrapper.deleteTo("/message");
        string = stringWrapper.after("/");
        return string;
    }
}

