/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.messageserver.server.facts.objectmodel;

import com.jronimo.messageserver.server.loaders.ServerFactsLoader;
import com.jronimo.messageserver.server.model.ActionConfig;
import com.jronimo.messageserver.server.model.AuthBundles;
import com.jronimo.messageserver.server.model.RuntimeConfig;
import com.jronimo.messageserver.server.model.Service;
import com.jronimo.messageserver.server.model.ServiceNamespace;
import com.jronimo.messageserver.server.model.SessionConfig;
import com.jronimo.messageserver.server.model.Sessions;
import com.jronimo.messageserver.server.model.UserAccounts;
import com.jronimo.messageserver.server.processes.PrerequisiteTasks;
import com.jronimo.messageserver.util.Constants;
import com.jronimo.util.Logger;
import com.jronimo.util.StringRegistry;
import com.jronimo.util.StringWrapper;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;

public class ServerFacts {
    private static final Logger logger = Logger.getLogger(ServerFacts.class);
    private ServletConfig servletConfig;
    private RuntimeConfig runtimeConfig;
    private String messageServerName;
    private boolean isMaster;
    private boolean isMinor;
    private String masterAddress;
    private Map<String, String> properties;
    private SessionConfig sessionConfig;
    private File messageServerDirectory;
    private String validationHtml;
    private String signUpValidationMessage;
    private String resetIdentifierValidationMessage;
    private Map<String, ServiceNamespace> serviceNamespaces;
    private UserAccounts userAccounts;
    private AuthBundles authBundles;
    private Sessions sessions;
    private final StringRegistry stringRegistry = new StringRegistry();
    private String url;

    public ServerFacts(Details details) {
        this.servletConfig = details.servletConfig;
        this.runtimeConfig = details.runtimeConfig;
        this.messageServerName = details.messageServerName;
        this.isMaster = details.isMaster;
        this.isMinor = details.isMinor;
        this.masterAddress = details.masterAddress;
        this.properties = details.properties;
        this.sessionConfig = details.sessionConfig;
        this.messageServerDirectory = details.messageServerDirectory;
        this.validationHtml = details.validationHtml;
        this.signUpValidationMessage = details.signUpValidationMessage;
        this.resetIdentifierValidationMessage = details.resetIdentifierValidationMessage;
        this.serviceNamespaces = details.serviceNamespaces;
        this.userAccounts = details.userAccounts;
        this.authBundles = details.authBundles;
        this.sessions = details.sessions;
    }

    public StringRegistry getStringRegistry() {
        return this.stringRegistry;
    }

    public ServletConfig getServletConfig() {
        return this.servletConfig;
    }

    public RuntimeConfig getRuntimeConfig() {
        return this.runtimeConfig;
    }

    public boolean isMaster() {
        return this.isMaster;
    }

    public boolean isMinor() {
        return this.isMinor;
    }

    public String getMasterAddress() {
        return this.masterAddress;
    }

    public String getProperty(String string) {
        return this.properties.get(string);
    }

    public Constants.UserAccountStrategy getUserAccountStrategy() {
        return this.runtimeConfig.getUserAccountStrategy();
    }

    public int getNextId() {
        return this.runtimeConfig.getNextId();
    }

    public String getMessageServerName() {
        return this.messageServerName;
    }

    public File getMessageServerDirectory() {
        return this.messageServerDirectory;
    }

    public String getSignUpValidationMessage() {
        return this.signUpValidationMessage;
    }

    public String getResetIdentifierValidationMessage() {
        return this.resetIdentifierValidationMessage;
    }

    public String getValidationHtml() {
        return this.validationHtml;
    }

    public File getMessageServerDirectory(String string) {
        return new File(this.messageServerDirectory, string);
    }

    public UserAccounts getUserAccounts() {
        return this.userAccounts;
    }

    public AuthBundles getAuthBundles() {
        return this.authBundles;
    }

    public SessionConfig getSessionConfig() {
        return this.sessionConfig;
    }

    public Sessions getSessions() {
        return this.sessions;
    }

    public synchronized String getUrl(HttpServletRequest httpServletRequest) {
        String string = null;
        StringWrapper stringWrapper = null;
        if (this.url == null) {
            stringWrapper = new StringWrapper("http://").append(httpServletRequest.getServerName()).append(":").append(httpServletRequest.getServerPort()).append(httpServletRequest.getRequestURI());
            this.url = stringWrapper.toString();
        }
        string = this.url;
        return string;
    }

    public ActionConfig getActionConfig(String string, String string2, String string3) {
        ActionConfig actionConfig = null;
        ServiceNamespace serviceNamespace = null;
        Service service = null;
        serviceNamespace = this.serviceNamespaces.get(string);
        if (serviceNamespace != null && (service = serviceNamespace.getService(string2)) != null) {
            actionConfig = service.getActionConfig(string3);
        }
        return actionConfig;
    }

    public static synchronized ServerFacts createInstance(ServletConfig servletConfig, PrerequisiteTasks prerequisiteTasks) {
        return ServerFactsLoader.execute(servletConfig, prerequisiteTasks);
    }

    public static class Details {
        public ServletConfig servletConfig;
        public RuntimeConfig runtimeConfig;
        public String messageServerName;
        public boolean isMaster;
        public boolean isMinor;
        public String masterAddress;
        public Map<String, String> properties;
        public SessionConfig sessionConfig;
        public File messageServerDirectory;
        public String validationHtml;
        public String signUpValidationMessage;
        public String resetIdentifierValidationMessage;
        public Map<String, ServiceNamespace> serviceNamespaces = new HashMap<String, ServiceNamespace>(5);
        public UserAccounts userAccounts;
        public AuthBundles authBundles;
        public Sessions sessions;
    }
}

