/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.messageserver.server.facts.active;

import com.jronimo.messageserver.server.facts.objectmodel.ServerFacts;
import com.jronimo.messageserver.server.loaders.MessageFactsLoader;
import com.jronimo.messageserver.server.model.Action;
import com.jronimo.messageserver.server.model.ActionConfig;
import com.jronimo.messageserver.server.model.Session;
import com.jronimo.util.Logger;
import com.jronimo.xml.XmlElement;
import javax.servlet.http.HttpServletRequest;

public class MessageFacts {
    private static final Logger logger = Logger.getLogger(MessageFacts.class);
    private ServerFacts serverFacts;
    private HttpServletRequest request;
    private String httpMethod;
    private String requestUri;
    private String contextPath;
    private String additionalPath;
    private XmlElement xmlMessage;
    private Session session;
    private String target;
    private ActionConfig actionConfig;
    private Action actionInstance;

    public MessageFacts(Details details) {
        this.serverFacts = details.serverFacts;
        this.request = details.request;
        this.httpMethod = details.httpMethod;
        this.requestUri = details.requestUri;
        this.contextPath = details.contextPath;
        this.additionalPath = details.additionalPath;
        this.xmlMessage = details.xmlMessage;
        this.session = details.session;
        this.target = details.target;
        this.actionConfig = details.actionConfig;
    }

    public boolean isValid() {
        return this.hasMessage() && this.hasActionConfig() && (!this.actionConfig.getService().requiresSession() || this.hasSession());
    }

    public boolean hasMessage() {
        return this.xmlMessage != null;
    }

    public boolean hasActionConfig() {
        return this.actionConfig != null;
    }

    public boolean hasSession() {
        return this.session != null;
    }

    public ServerFacts getServerFacts() {
        return this.serverFacts;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public String getHttpMethod() {
        return this.httpMethod;
    }

    public boolean isGet() {
        return "get".equalsIgnoreCase(this.httpMethod);
    }

    public boolean isPost() {
        return "post".equalsIgnoreCase(this.httpMethod);
    }

    public String getRequestUri() {
        return this.requestUri;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public String getAdditionalPath() {
        return this.additionalPath;
    }

    public XmlElement getXmlMessage() {
        return this.xmlMessage;
    }

    public Session getSession() {
        return this.session;
    }

    public String getTarget() {
        return this.target;
    }

    public ActionConfig getActionConfig() {
        return this.actionConfig;
    }

    public synchronized Action getActionInstance() {
        Action action = null;
        if (this.actionInstance == null) {
            this.actionInstance = this.actionConfig.getActionInstance(this);
        }
        action = this.actionInstance;
        return action;
    }

    public static MessageFacts createInstance(ServerFacts serverFacts, HttpServletRequest httpServletRequest) {
        return MessageFactsLoader.execute(serverFacts, httpServletRequest);
    }

    public static class Details {
        public ServerFacts serverFacts;
        public HttpServletRequest request;
        public String httpMethod;
        public String requestUri;
        public String contextPath;
        public String additionalPath;
        public XmlElement xmlMessage;
        public Session session;
        public String target;
        public ActionConfig actionConfig;
    }
}

