/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.main;

import com.jezhumble.javasysmon.CpuTimes;
import com.jezhumble.javasysmon.JavaSysMon;
import com.jezhumble.javasysmon.MemoryStats;
import com.jronimo.http.HttpGet;
import com.jronimo.http.UrlParts;
import com.jronimo.text.ResourceText;
import com.jronimo.text.ResourceTextIdentifiers;
import com.jronimo.util.LibraryLifecycle;
import com.jronimo.util.Logger;
import com.jronimo.util.Methods;
import com.jronimo.webappengines.core.ClientSessionLocal;
import com.jronimo.webappengines.core.Constants;
import com.jronimo.webappengines.core.client.ClientSessionRemote;
import com.jronimo.webappengines.core.client.ClientSessionResponse;
import com.jronimo.webappengines.core.client.ConnectionError;
import com.jronimo.webappengines.core.client.SimpleSender;
import com.jronimo.xml.XmlElement;
import com.jronimo.xml.XmlElementFactory;
import java.io.File;
import java.util.Map;

public class Main {
    private static final Logger logger = Logger.getLogger(Main.class);

    private Main() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void main(String[] stringArray) {
        System.out.println("HELLO FROM MAIN");
        try {
            Class.forName("com.jronimo.util.LibraryLifecycle");
            Main.testRandomNumber();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            LibraryLifecycle.shutdown();
            System.out.println("GOODBYE FROM MAIN");
        }
    }

    private static void testRandomNumber() throws Exception {
        int n;
        int[] nArray = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        int n2 = 1000;
        int n3 = 0;
        for (n = 1; n < n2; ++n) {
            n3 = (int)Methods.getRandomNumber(1L, 10L);
            int n4 = --n3;
            nArray[n4] = nArray[n4] + 1;
        }
        int n5 = nArray.length;
        for (n = 0; n < n5; ++n) {
            logger.debug(n + 1 + ": " + Math.round((double)nArray[n] / (double)n2 * 100.0));
        }
    }

    private static void testSystemCoreUrl() throws Exception {
        HttpGet httpGet = null;
        Object var1_1 = null;
        httpGet = new HttpGet(new UrlParts("http://localhost:8080/home/systemCoreUrl?si=com.jronimo.hgasystems.hgaexample"));
        httpGet.execute();
        logger.debug(new String(httpGet.getReturnedBytes(), "UTF-8"));
    }

    private static void testFileService() throws Exception {
        HttpGet httpGet = null;
        Map<String, String> map = null;
        httpGet = new HttpGet(new UrlParts("http://localhost:8080/system/fileservice-versioncheck?si=com.jronimo.hgasystems.hgaexample&version=1.0"));
        httpGet.execute(true);
        map = httpGet.getHeaders();
        logger.debug(new String(httpGet.getReturnedBytes(), "UTF-8"));
        for (String string : map.keySet()) {
            logger.debug(string + ": " + map.get(string));
        }
    }

    private static void testEchoXml() {
        new SimpleSender("localhost", "/system/echo", 8080).execute();
    }

    private static void testClientSessionRemote() {
        UrlParts urlParts = null;
        ClientSessionRemote clientSessionRemote = null;
        ConnectionError connectionError = null;
        urlParts = new UrlParts("http", "localhost", "/system/dataservice-post", 8080);
        clientSessionRemote = new ClientSessionRemote("com.jronimo.hgasystems.hgaexample", urlParts);
        connectionError = clientSessionRemote.connect("Guest", "guest", "en", "British", "en_AU");
        logger.debug("Connection Success: " + (connectionError == null));
        Main.sendRequest(clientSessionRemote, "List");
        Main.sendRequest(clientSessionRemote, "Get");
        Main.sendRequest(clientSessionRemote, "Create");
        Main.sendRequest(clientSessionRemote, "Update");
        Main.sendRequest(clientSessionRemote, "Delete");
    }

    private static void testClientSessionLocal() {
        File file = null;
        ClientSessionLocal clientSessionLocal = null;
        ConnectionError connectionError = null;
        file = new File("C:/Files/Documents/Projects/HGADevelopments/Systems/HGAExample/Software/WebApps/SystemsContainer/root");
        clientSessionLocal = new ClientSessionLocal("com.jronimo.hgasystems.hgaexample", file);
        connectionError = clientSessionLocal.connect("Guest", "guest", "en", "British", "en_AU");
        logger.debug("Connection Success: " + (connectionError == null));
        Main.sendRequest(clientSessionLocal, "List");
        Main.sendRequest(clientSessionLocal, "Get");
        Main.sendRequest(clientSessionLocal, "Create");
        Main.sendRequest(clientSessionLocal, "Update");
        Main.sendRequest(clientSessionLocal, "Delete");
    }

    private static void textXml() {
        File file = null;
        File file2 = null;
        XmlElement xmlElement = null;
        file = new File("C:/Files/Documents/Projects/HGADevelopments/Systems/HGAExample/Software/XML/DataService Message");
        file2 = new File(file, "Person_Request_Get.xml");
        xmlElement = XmlElementFactory.load(file2);
        logger.debug(xmlElement.getElement("operation/id").getElement("../../operation").getElement("id"));
        logger.debug(xmlElement.getElement("operation/id").getText());
        logger.debug(xmlElement.getInteger("operation/id"));
    }

    private static void sendRequest(ClientSessionRemote clientSessionRemote, String string) {
        File file = null;
        File file2 = null;
        XmlElement xmlElement = null;
        ClientSessionResponse clientSessionResponse = null;
        file = new File("C:/Files/Documents/Projects/HGADevelopments/Systems/HGAExample/Software/XML/DataService Message");
        file2 = new File(file, "Person_Request_" + string + ".xml");
        xmlElement = XmlElementFactory.load(file2);
        logger.debug("");
        logger.debug(string.toUpperCase());
        clientSessionResponse = clientSessionRemote.sendRequest(Constants.DataServiceRequestType.DATA_SERVICE, xmlElement);
        if (clientSessionResponse.hasError()) {
            logger.debug(clientSessionResponse.getError().getErrorElement());
        } else {
            logger.debug(clientSessionResponse.getServiceResponseElement());
        }
    }

    private static void sendRequest(ClientSessionLocal clientSessionLocal, String string) {
        File file = null;
        File file2 = null;
        XmlElement xmlElement = null;
        ClientSessionResponse clientSessionResponse = null;
        file = new File("C:/Files/Documents/Projects/HGADevelopments/Systems/HGAExample/Software/XML/DataService Message");
        file2 = new File(file, "Person_Request_" + string + ".xml");
        xmlElement = XmlElementFactory.load(file2);
        logger.debug("");
        logger.debug(string.toUpperCase());
        clientSessionResponse = clientSessionLocal.sendRequest(Constants.DataServiceRequestType.DATA_SERVICE, xmlElement);
        if (clientSessionResponse.hasError()) {
            logger.debug(clientSessionResponse.getError().getErrorElement());
        } else {
            logger.debug(clientSessionResponse.getServiceResponseElement());
        }
    }

    private static void testConstraints() throws Exception {
        Class.forName("com.jronimo.constraints.Constraints");
    }

    private static void testText() throws Exception {
        logger.debug("TEXT: " + ResourceText.getText((Object)ResourceTextIdentifiers.MUST_NOT_BE_NULL));
        logger.debug("TEXT: " + ResourceText.getText((Object)ResourceTextIdentifiers.MUST_NOT_BE_NULL));
    }

    private static void testJavaSysMon() {
        Main.displayMemoryUsage();
        Main.displayCpuStats();
        Main.displayCpuUsage();
    }

    private static void displayMemoryUsage() {
        JavaSysMon javaSysMon = null;
        MemoryStats memoryStats = null;
        int n = 0;
        javaSysMon = new JavaSysMon();
        memoryStats = javaSysMon.physical();
        n = (int)Math.ceil(100.0 * ((double)(memoryStats.getTotalBytes() - memoryStats.getFreeBytes()) / (double)memoryStats.getTotalBytes()));
        logger.debug("Memory Usage: " + n);
    }

    private static void displayCpuStats() {
        JavaSysMon javaSysMon = null;
        CpuTimes cpuTimes = null;
        CpuTimes cpuTimes2 = null;
        int n = 0;
        javaSysMon = new JavaSysMon();
        cpuTimes = javaSysMon.cpuTimes();
        Methods.sleep(10000L);
        cpuTimes2 = javaSysMon.cpuTimes();
        n = (int)Math.round(100.0 * ((double)(cpuTimes2.getIdleMillis() - cpuTimes.getIdleMillis()) / (double)(cpuTimes2.getTotalMillis() - cpuTimes.getTotalMillis())));
        logger.debug("Idle percentage: " + n);
        n = (int)Math.round(100.0 * ((double)(cpuTimes2.getUserMillis() - cpuTimes.getUserMillis()) / (double)(cpuTimes2.getTotalMillis() - cpuTimes.getTotalMillis())));
        logger.debug("User percentage: " + n);
        n = (int)Math.round(100.0 * ((double)(cpuTimes2.getSystemMillis() - cpuTimes.getSystemMillis()) / (double)(cpuTimes2.getTotalMillis() - cpuTimes.getTotalMillis())));
        logger.debug("System percentage: " + n);
    }

    private static void displayCpuUsage() {
        JavaSysMon javaSysMon = null;
        CpuTimes cpuTimes = null;
        CpuTimes cpuTimes2 = null;
        int n = 0;
        javaSysMon = new JavaSysMon();
        cpuTimes = javaSysMon.cpuTimes();
        Methods.sleep(10000L);
        cpuTimes2 = javaSysMon.cpuTimes();
        n = (int)Math.floor(100.0 * ((double)(cpuTimes2.getIdleMillis() - cpuTimes.getIdleMillis()) / (double)(cpuTimes2.getTotalMillis() - cpuTimes.getTotalMillis())));
        logger.debug("CPU usage: " + (100 - n));
    }
}

