/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.internationalization;

import com.jronimo.collections.collection.CollectionUtils;
import com.jronimo.internationalization.Language;
import com.jronimo.util.Logger;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;

public class Languages {
    private static final Logger logger = Logger.getLogger(Languages.class);
    private static Languages instance = new Languages();
    private Set<Language> languages = CollectionUtils.getOrderedSet(new HashSet());

    private Languages() {
        this.languages.add(new Language("en"));
        this.languages.add(new Language("en", "US", new String[]{"US"}));
        this.languages.add(new Language("en", "British", true));
    }

    public static Languages getInstance() {
        return instance;
    }

    public Language getPrimary(Locale locale) {
        Language language = null;
        for (Language language2 : this.languages) {
            if (language2.isVariation() || !language2.matches(locale)) continue;
            language = language2;
            break;
        }
        return language;
    }

    public Language getVariation(Locale locale) {
        Language language = null;
        for (Language language2 : this.languages) {
            if (!language2.isVariation() || !language2.matches(locale)) continue;
            language = language2;
            break;
        }
        if (language == null) {
            for (Language language2 : this.languages) {
                if (!language2.isDefaultVariation(locale)) continue;
                language = language2;
                break;
            }
        }
        return language;
    }

    public Language getPrimary(String string) {
        Language language = null;
        for (Language language2 : this.languages) {
            if (language2.isVariation() || !language2.matches(string)) continue;
            language = language2;
            break;
        }
        return language;
    }

    public Language getVariation(String string, String string2) {
        Language language = null;
        for (Language language2 : this.languages) {
            if (!language2.isVariation() || !language2.matches(string, string2)) continue;
            language = language2;
            break;
        }
        if (language == null) {
            for (Language language2 : this.languages) {
                if (!language2.isDefaultVariation(string)) continue;
                language = language2;
                break;
            }
        }
        return language;
    }
}

